/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.io.File;
import processing.core.PApplet;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.image.CSequence;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.CompressedFrameInfo;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.QTImage;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.movies.media.VideoMedia;
import quicktime.util.EncodedImage;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;

public class MovieMaker {
    public static final int RAW = 1918990112;
    public static final int ANIMATION = 1919706400;
    public static final int BASE = 1650553701;
    public static final int BMP = 1465011269;
    public static final int CINEPAK = 1668704612;
    public static final int COMPONENT = 2037741106;
    public static final int CMYK = 1668118891;
    public static final int GIF = 1734960672;
    public static final int GRAPHICS = 1936548640;
    public static final int H261 = 1748121137;
    public static final int H263 = 1748121139;
    public static final int H264 = QTUtils.toOSType((String)"avc1");
    public static final int JPEG = 1785750887;
    public static final int MS_VIDEO = 1836283491;
    public static final int MOTION_JPEG_A = 1835692129;
    public static final int MOTION_JPEG_B = 1835692130;
    public static final int SORENSON = 1398165809;
    public static final int VIDEO = 1919973985;
    public static final int WORST = 0;
    public static final int LOW = 256;
    public static final int MEDIUM = 512;
    public static final int HIGH = 768;
    public static final int BEST = 1023;
    public static final int LOSSLESS = 1024;
    private int width;
    private int height;
    private boolean readyForFrames;
    private int TIME_SCALE = 600;
    private VideoMedia videoMedia;
    private Track videoTrack;
    private Movie movie;
    private QTFile movFile;
    private CSequence seq;
    private QTHandle imageHandle;
    private QDGraphics gw;
    private QDRect bounds;
    private ImageDescription imgDesc;
    private RawEncodedImage compressedImage;
    private int rate;
    private int keyFrameRate = 15;
    private int codecType;
    private int codecQuality;
    private boolean temporalSupported = true;
    private PApplet parent;

    public MovieMaker(PApplet p, int _w, int _h, String _filename) {
        this(p, _w, _h, _filename, 30, 1918990112, 768, 15);
    }

    public MovieMaker(PApplet p, int _w, int _h, String _filename, int _rate) {
        this(p, _w, _h, _filename, _rate, 1918990112, 768, 15);
    }

    public MovieMaker(PApplet p, int _w, int _h, String _filename, int _rate, int _codecType, int _codecQuality) {
        this(p, _w, _h, _filename, _rate, _codecType, _codecQuality, 15);
    }

    public MovieMaker(PApplet p, int _w, int _h, String _filename, int _rate, int _codecType, int _codecQuality, int _keyFrameRate) {
        this.parent = p;
        this.width = _w;
        this.height = _h;
        this.rate = _rate;
        try {
            QTSession.open();
        }
        catch (QTException e1) {
            e1.printStackTrace();
        }
        try {
            ImageDescription imgD = null;
            imgD = EndianOrder.isNativeLittleEndian() ? new ImageDescription(1111970369) : new ImageDescription(QDGraphics.kDefaultPixelFormat);
            imgD.setWidth(this.width);
            imgD.setHeight(this.height);
            this.gw = new QDGraphics(imgD, 0);
        }
        catch (QTException e) {
            e.printStackTrace();
        }
        this.codecType = _codecType;
        this.codecQuality = _codecQuality;
        this.keyFrameRate = _keyFrameRate;
        this.initMovie(_filename);
        this.parent.registerDispose(this);
    }

    private void initMovie(String filename) {
        try {
            String path = this.parent.savePath(filename);
            this.movFile = new QTFile(new File(path));
            this.movie = Movie.createMovieFile((QTFile)this.movFile, (int)1414942532, (int)Integer.MIN_VALUE);
            int timeScale = this.TIME_SCALE;
            this.videoTrack = this.movie.addTrack((float)this.width, (float)this.height, 0.0f);
            this.videoMedia = new VideoMedia(this.videoTrack, timeScale);
            this.videoMedia.beginEdits();
            this.bounds = new QDRect(0, 0, this.width, this.height);
            int rawImageSize = QTImage.getMaxCompressionSize((QDGraphics)this.gw, (QDRect)this.bounds, (int)this.gw.getPixMap().getPixelSize(), (int)this.codecQuality, (int)this.codecType, (CodecComponent)CodecComponent.anyCodec);
            this.imageHandle = new QTHandle(rawImageSize, true);
            this.imageHandle.lock();
            this.compressedImage = RawEncodedImage.fromQTHandle((QTHandleRef)this.imageHandle);
            this.seq = new CSequence(this.gw, this.bounds, this.gw.getPixMap().getPixelSize(), this.codecType, CodecComponent.bestFidelityCodec, this.codecQuality, this.codecQuality, this.keyFrameRate, null, 0);
            this.imgDesc = this.seq.getDescription();
            this.readyForFrames = true;
        }
        catch (QTException e) {
            if (e.errorCode() == -8961) {
                if (this.imageHandle == null) {
                    System.err.println("The specified codec is not supported, please ensure that the parameters are valid, and in the correct order.");
                } else {
                    this.temporalSupported = false;
                    this.readyForFrames = true;
                }
            }
            if (e.errorCode() == -47) {
                System.err.println("The movie file already exists.  Please delete it first.");
            }
            e.printStackTrace();
        }
    }

    public void addFrame() {
        this.parent.flush();
        this.parent.loadPixels();
        this.addFrame(this.parent.pixels, this.parent.width, this.parent.height);
    }

    public void addFrame(int[] _pixels, int w, int h) {
        if (this.readyForFrames) {
            RawEncodedImage pixelData = this.gw.getPixMap().getPixelData();
            int rowBytes = pixelData.getRowBytes() / 4;
            int[] newpixels = new int[rowBytes * h];
            int i = 0;
            while (i < rowBytes) {
                int j = 0;
                while (j < h) {
                    newpixels[i + j * rowBytes] = i < w ? _pixels[i + j * w] : 0;
                    ++j;
                }
                ++i;
            }
            pixelData.setInts(0, newpixels);
            this.compressAndAdd();
        }
    }

    private void compressAndAdd() {
        try {
            if (this.temporalSupported) {
                CompressedFrameInfo cfInfo = this.seq.compressFrame(this.gw, this.bounds, 4, this.compressedImage);
                boolean syncSample = cfInfo.getSimilarity() == 0;
                this.videoMedia.addSample((QTHandleRef)this.imageHandle, 0, cfInfo.getDataSize(), this.TIME_SCALE / this.rate, (SampleDescription)this.imgDesc, 1, syncSample ? 0 : 1);
            } else {
                this.imgDesc = QTImage.fCompress((QDGraphics)this.gw, (QDRect)this.gw.getBounds(), (int)32, (int)this.codecQuality, (int)this.codecType, (CodecComponent)CodecComponent.anyCodec, null, (int)0, (EncodedImage)RawEncodedImage.fromQTHandle((QTHandleRef)this.imageHandle));
                boolean syncSample = true;
                this.videoMedia.addSample((QTHandleRef)this.imageHandle, 0, this.imgDesc.getDataSize(), this.TIME_SCALE / this.rate, (SampleDescription)this.imgDesc, 1, syncSample ? 0 : 1);
            }
        }
        catch (QTException e) {
            e.printStackTrace();
        }
    }

    public void finish() {
        try {
            if (this.readyForFrames) {
                this.readyForFrames = false;
                this.videoMedia.endEdits();
                this.videoTrack.insertMedia(0, 0, this.videoMedia.getDuration(), 1.0f);
                OpenMovieFile omf = OpenMovieFile.asWrite((QTFile)this.movFile);
                this.movie.addResource(omf, -1, this.movFile.getName());
            }
        }
        catch (StdQTException se) {
            se.printStackTrace();
        }
        catch (QTException qe) {
            qe.printStackTrace();
        }
    }

    public void dispose() {
        if (this.readyForFrames) {
            this.finish();
        }
        try {
            QTSession.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

