/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.util.AnimatorBase;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import processing.opengl.PGraphicsOpenGL;

public class PGL {
    protected static final int AWT = 0;
    protected static final int NEWT = 1;
    protected static final int SIZEOF_SHORT = 2;
    protected static final int SIZEOF_INT = 4;
    protected static final int SIZEOF_FLOAT = 4;
    protected static final int SIZEOF_BYTE = 1;
    protected static final int SIZEOF_INDEX = 2;
    protected static final int INDEX_TYPE = 5123;
    protected static final int DEFAULT_IN_VERTICES = 64;
    protected static final int DEFAULT_IN_EDGES = 128;
    protected static final int DEFAULT_IN_TEXTURES = 64;
    protected static final int DEFAULT_TESS_VERTICES = 64;
    protected static final int DEFAULT_TESS_INDICES = 128;
    protected static final int MAX_LIGHTS = 8;
    protected static final int MAX_VERTEX_INDEX = Short.MAX_VALUE;
    protected static final int MAX_VERTEX_INDEX1 = 32768;
    protected static final int FLUSH_VERTEX_COUNT = 32768;
    protected static final int MAX_FONT_TEX_SIZE = 1024;
    protected static final float MIN_CAPS_JOINS_WEIGHT = 2.0f;
    protected static final int MAX_CAPS_JOINS_LENGTH = 5000;
    protected static final int MIN_ARRAYCOPY_SIZE = 2;
    protected static final boolean MIPMAPS_ENABLED = true;
    protected static float FLOAT_EPS = Float.MIN_VALUE;
    protected static boolean BIG_ENDIAN;
    protected static final String SHADER_PREPROCESSOR_DIRECTIVE = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\n";
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int LESS = 513;
    public static final int LEQUAL = 515;
    public static final int CCW = 2305;
    public static final int CW = 2304;
    public static final int CULL_FACE = 2884;
    public static final int FRONT = 1028;
    public static final int BACK = 1029;
    public static final int FRONT_AND_BACK = 1032;
    public static final int VIEWPORT = 2978;
    public static final int SCISSOR_TEST = 3089;
    public static final int DEPTH_TEST = 2929;
    public static final int DEPTH_WRITEMASK = 2930;
    public static final int COLOR_BUFFER_BIT = 16384;
    public static final int DEPTH_BUFFER_BIT = 256;
    public static final int STENCIL_BUFFER_BIT = 1024;
    public static final int FUNC_ADD = 32774;
    public static final int FUNC_MIN = 32775;
    public static final int FUNC_MAX = 32776;
    public static final int FUNC_REVERSE_SUBTRACT = 32779;
    public static final int TEXTURE_2D = 3553;
    public static final int TEXTURE_RECTANGLE = 34037;
    public static final int TEXTURE_BINDING_2D = 32873;
    public static final int TEXTURE_BINDING_RECTANGLE = 34038;
    public static final int RGB = 6407;
    public static final int RGBA = 6408;
    public static final int ALPHA = 6406;
    public static final int UNSIGNED_INT = 5125;
    public static final int UNSIGNED_BYTE = 5121;
    public static final int UNSIGNED_SHORT = 5123;
    public static final int FLOAT = 5126;
    public static final int NEAREST = 9728;
    public static final int LINEAR = 9729;
    public static final int LINEAR_MIPMAP_NEAREST = 9985;
    public static final int LINEAR_MIPMAP_LINEAR = 9987;
    public static final int CLAMP_TO_EDGE = 33071;
    public static final int REPEAT = 10497;
    public static final int RGBA8 = 32856;
    public static final int DEPTH24_STENCIL8 = 35056;
    public static final int DEPTH_COMPONENT = 6402;
    public static final int DEPTH_COMPONENT16 = 33189;
    public static final int DEPTH_COMPONENT24 = 33190;
    public static final int DEPTH_COMPONENT32 = 33191;
    public static final int STENCIL_INDEX = 6401;
    public static final int STENCIL_INDEX1 = 36166;
    public static final int STENCIL_INDEX4 = 36167;
    public static final int STENCIL_INDEX8 = 36168;
    public static final int ARRAY_BUFFER = 34962;
    public static final int ELEMENT_ARRAY_BUFFER = 34963;
    public static final int SAMPLES = 32937;
    public static final int FRAMEBUFFER_COMPLETE = 36053;
    public static final int FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int FRAMEBUFFER_INCOMPLETE_FORMATS = 36058;
    public static final int FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
    public static final int FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
    public static final int FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int STATIC_DRAW = 35044;
    public static final int DYNAMIC_DRAW = 35048;
    public static final int STREAM_DRAW = 35040;
    public static final int READ_ONLY = 35000;
    public static final int WRITE_ONLY = 35001;
    public static final int READ_WRITE = 35002;
    public static final int TRIANGLE_FAN = 6;
    public static final int TRIANGLE_STRIP = 5;
    public static final int TRIANGLES = 4;
    public static final int VENDOR = 7936;
    public static final int RENDERER = 7937;
    public static final int VERSION = 7938;
    public static final int EXTENSIONS = 7939;
    public static final int SHADING_LANGUAGE_VERSION = 35724;
    public static final int MAX_TEXTURE_SIZE = 3379;
    public static final int MAX_SAMPLES = 36183;
    public static final int ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int DEPTH_BITS = 3414;
    public static final int STENCIL_BITS = 3415;
    public static final int TESS_WINDING_NONZERO = 100131;
    public static final int TESS_WINDING_ODD = 100130;
    public static final int TEXTURE0 = 33984;
    public static final int TEXTURE1 = 33985;
    public static final int TEXTURE2 = 33986;
    public static final int TEXTURE3 = 33987;
    public static final int TEXTURE_MIN_FILTER = 10241;
    public static final int TEXTURE_MAG_FILTER = 10240;
    public static final int TEXTURE_WRAP_S = 10242;
    public static final int TEXTURE_WRAP_T = 10243;
    public static final int BLEND = 3042;
    public static final int ONE = 1;
    public static final int ZERO = 0;
    public static final int SRC_ALPHA = 770;
    public static final int DST_ALPHA = 772;
    public static final int ONE_MINUS_SRC_ALPHA = 771;
    public static final int ONE_MINUS_DST_COLOR = 775;
    public static final int ONE_MINUS_SRC_COLOR = 769;
    public static final int DST_COLOR = 774;
    public static final int SRC_COLOR = 768;
    public static final int FRAMEBUFFER = 36160;
    public static final int COLOR_ATTACHMENT0 = 36064;
    public static final int COLOR_ATTACHMENT1 = 36065;
    public static final int COLOR_ATTACHMENT2 = 36066;
    public static final int COLOR_ATTACHMENT3 = 36067;
    public static final int RENDERBUFFER = 36161;
    public static final int DEPTH_ATTACHMENT = 36096;
    public static final int STENCIL_ATTACHMENT = 36128;
    public static final int READ_FRAMEBUFFER = 36008;
    public static final int DRAW_FRAMEBUFFER = 36009;
    public static final int VERTEX_SHADER = 35633;
    public static final int FRAGMENT_SHADER = 35632;
    public static final int INFO_LOG_LENGTH = 35716;
    public static final int SHADER_SOURCE_LENGTH = 35720;
    public static final int COMPILE_STATUS = 35713;
    public static final int LINK_STATUS = 35714;
    public static final int VALIDATE_STATUS = 35715;
    public static final int MULTISAMPLE = 32925;
    public static final int POINT_SMOOTH = 2832;
    public static final int LINE_SMOOTH = 2848;
    public static final int POLYGON_SMOOTH = 2881;
    public GL gl;
    public GLU glu;
    public GLContext context;
    public Canvas canvas;
    protected GL2ES2 gl2;
    protected GL2 gl2x;
    protected PGraphicsOpenGL pg;
    protected boolean initialized;
    protected static int toolkit;
    protected GLProfile profile;
    protected GLCapabilitiesImmutable capabilities;
    protected GLDrawable drawable;
    protected GLCanvas canvasAWT;
    protected NewtCanvasAWT canvasNEWT;
    protected GLWindow window;
    protected PGLListener listener;
    protected PGLAnimator animator;
    protected float targetFramerate = 60.0f;
    protected boolean setFramerate = false;
    protected static boolean[] texturingTargets;
    protected static int[] boundTextures;
    protected static final boolean ENABLE_OSX_SCREEN_FBO = true;
    protected static final int MIN_OSX_VER_FOR_SCREEN_FBO = 6;
    protected static final int MIN_SAMPLES_FOR_SCREEN_FBO = 1;
    protected boolean needScreenFBO = false;
    protected int fboWidth;
    protected int fboHeight;
    protected int numSamples;
    protected boolean multisample;
    protected boolean packedDepthStencil;
    protected int backTex;
    protected int frontTex;
    protected int[] glColorTex = new int[]{0, 0};
    protected int[] glColorFbo = new int[]{0};
    protected int[] glMultiFbo = new int[]{0};
    protected int[] glColorRenderBuffer = new int[]{0};
    protected int[] glPackedDepthStencil = new int[]{0};
    protected int[] glDepthBuffer = new int[]{0};
    protected int[] glStencilBuffer = new int[]{0};
    protected int contextHashCode;
    protected boolean loadedTex2DShader = false;
    protected int tex2DShaderProgram;
    protected int tex2DVertShader;
    protected int tex2DFragShader;
    protected GLContext tex2DShaderContext;
    protected int tex2DVertLoc;
    protected int tex2DTCoordLoc;
    protected boolean loadedTexRectShader = false;
    protected int texRectShaderProgram;
    protected int texRectVertShader;
    protected int texRectFragShader;
    protected GLContext texRectShaderContext;
    protected int texRectVertLoc;
    protected int texRectTCoordLoc;
    protected float[] texCoords = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    protected FloatBuffer texData;
    protected String texVertShaderSource = "attribute vec2 inVertex;attribute vec2 inTexcoord;varying vec2 vertTexcoord;void main() {  gl_Position = vec4(inVertex, 0, 1);  vertTexcoord = inTexcoord;}";
    protected String tex2DFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform sampler2D textureSampler;varying vec2 vertTexcoord;void main() {  gl_FragColor = texture2D(textureSampler, vertTexcoord.st);}";
    protected String texRectFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform sampler2DRect textureSampler;varying vec2 vertTexcoord;void main() {  gl_FragColor = texture2DRect(textureSampler, vertTexcoord.st);}";
    protected IntBuffer colorBuffer;
    protected FloatBuffer depthBuffer;
    protected ByteBuffer stencilBuffer;

    public PGL(PGraphicsOpenGL pg) {
        this.pg = pg;
        this.glu = new GLU();
        this.initialized = false;
    }

    protected void setFrameRate(float framerate) {
        if (this.targetFramerate != framerate) {
            if (60.0f < framerate) {
                this.gl.setSwapInterval(0);
            } else if (30.0f < framerate) {
                this.gl.setSwapInterval(1);
            } else {
                this.gl.setSwapInterval(2);
            }
            if (60.0f < framerate && this.targetFramerate <= 60.0f || framerate <= 60.0f && 60.0f < this.targetFramerate) {
                this.initialized = false;
            }
            this.targetFramerate = framerate;
            this.setFramerate = true;
        }
    }

    protected void initPrimarySurface(int antialias) {
        int num;
        String version;
        String[] parts;
        this.needScreenFBO = false;
        this.glColorFbo[0] = 0;
        String osName = System.getProperty("os.name");
        if (osName.equals("Mac OS X") && 2 <= (parts = (version = System.getProperty("os.version")).split("\\.")).length && 6 <= (num = Integer.parseInt(parts[1])) && 1 <= this.qualityToSamples(this.pg.quality)) {
            this.needScreenFBO = true;
        }
        if (this.profile == null) {
            this.profile = GLProfile.getDefault();
        } else {
            if (this.canvasAWT != null) {
                this.canvasAWT.removeGLEventListener(this.listener);
                this.pg.parent.removeListeners(this.canvasAWT);
                this.pg.parent.remove(this.canvasAWT);
            } else if (this.canvasNEWT != null) {
                this.animator.stop();
                this.animator.remove(this.window);
                this.window.removeGLEventListener(this.listener);
                this.pg.parent.removeListeners(this.canvasNEWT);
                this.pg.parent.remove(this.canvasNEWT);
            }
            this.setFramerate = false;
        }
        GLCapabilities caps = new GLCapabilities(this.profile);
        if (1 < antialias && !this.needScreenFBO) {
            caps.setSampleBuffers(true);
            caps.setNumSamples(antialias);
        } else {
            caps.setSampleBuffers(false);
        }
        caps.setDepthBits(24);
        caps.setStencilBits(8);
        caps.setAlphaBits(8);
        caps.setBackgroundOpaque(true);
        if (toolkit == 0) {
            this.canvasAWT = new GLCanvas(caps);
            this.canvasAWT.setBounds(0, 0, this.pg.width, this.pg.height);
            this.pg.parent.setLayout(new BorderLayout());
            this.pg.parent.add((Component)this.canvasAWT, "Center");
            this.pg.parent.removeListeners(this.pg.parent);
            this.pg.parent.addListeners(this.canvasAWT);
            this.listener = new PGLListener();
            this.canvasAWT.addGLEventListener(this.listener);
            this.capabilities = this.canvasAWT.getChosenGLCapabilities();
            this.canvas = this.canvasAWT;
            this.canvasNEWT = null;
        } else if (toolkit == 1) {
            this.window = GLWindow.create(caps);
            this.canvasNEWT = new NewtCanvasAWT(this.window);
            this.pg.parent.setLayout(new BorderLayout());
            this.pg.parent.add((Component)this.canvasNEWT, "Center");
            this.pg.parent.removeListeners(this.pg.parent);
            this.pg.parent.addListeners(this.canvasNEWT);
            this.listener = new PGLListener();
            this.window.addGLEventListener(this.listener);
            this.animator = new PGLAnimator(this.window);
            this.animator.start();
            this.capabilities = this.window.getChosenGLCapabilities();
            this.canvas = this.canvasNEWT;
            this.canvasAWT = null;
        }
        this.initialized = true;
    }

    protected void initOffscreenSurface(PGL primary) {
        this.context = primary.context;
        this.capabilities = primary.capabilities;
        this.drawable = null;
        this.initialized = true;
    }

    protected void updatePrimary() {
        if (!this.setFramerate) {
            this.setFrameRate(this.targetFramerate);
        }
        if (this.needScreenFBO && this.glColorFbo[0] == 0) {
            this.numSamples = this.qualityToSamples(this.pg.quality);
            String ext = this.gl.glGetString(7939);
            if (-1 < ext.indexOf("texture_non_power_of_two")) {
                this.fboWidth = this.pg.width;
                this.fboHeight = this.pg.height;
            } else {
                this.fboWidth = PGL.nextPowerOfTwo(this.pg.width);
                this.fboHeight = PGL.nextPowerOfTwo(this.pg.height);
            }
            boolean bl = this.multisample = 1 < this.numSamples;
            if (this.multisample && this.gl2x == null) {
                throw new RuntimeException("Doesn't have the OpenGL extensions necessary for multisampling.");
            }
            this.packedDepthStencil = ext.indexOf("packed_depth_stencil") != -1;
            this.contextHashCode = this.context.hashCode();
            this.gl.glGenTextures(2, this.glColorTex, 0);
            for (int i = 0; i < 1; ++i) {
                this.gl.glBindTexture(3553, this.glColorTex[i]);
                this.gl.glTexParameteri(3553, 10241, 9728);
                this.gl.glTexParameteri(3553, 10240, 9728);
                this.gl.glTexParameteri(3553, 10242, 33071);
                this.gl.glTexParameteri(3553, 10243, 33071);
                this.gl.glTexImage2D(3553, 0, 6408, this.fboWidth, this.fboHeight, 0, 6408, 5121, null);
                this.initTexture(3553, 6408, this.fboWidth, this.fboHeight);
            }
            this.gl.glBindTexture(3553, 0);
            this.gl.glGenFramebuffers(1, this.glColorFbo, 0);
            this.gl.glBindFramebuffer(36160, this.glColorFbo[0]);
            this.gl.glFramebufferTexture2D(36160, 36064, 3553, this.glColorTex[0], 0);
            if (this.multisample) {
                this.gl.glGenFramebuffers(1, this.glMultiFbo, 0);
                this.gl.glBindFramebuffer(36160, this.glMultiFbo[0]);
                this.gl.glGenRenderbuffers(1, this.glColorRenderBuffer, 0);
                this.gl.glBindRenderbuffer(36161, this.glColorRenderBuffer[0]);
                this.gl2x.glRenderbufferStorageMultisample(36161, this.numSamples, 32856, this.fboWidth, this.fboHeight);
                this.gl.glFramebufferRenderbuffer(36160, 36064, 36161, this.glColorRenderBuffer[0]);
                if (this.packedDepthStencil) {
                    this.gl.glGenRenderbuffers(1, this.glPackedDepthStencil, 0);
                    this.gl.glBindRenderbuffer(36161, this.glPackedDepthStencil[0]);
                    this.gl2x.glRenderbufferStorageMultisample(36161, this.numSamples, 35056, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.glPackedDepthStencil[0]);
                    this.gl.glFramebufferRenderbuffer(36160, 36128, 36161, this.glPackedDepthStencil[0]);
                } else {
                    this.gl.glGenRenderbuffers(1, this.glDepthBuffer, 0);
                    this.gl.glBindRenderbuffer(36161, this.glDepthBuffer[0]);
                    this.gl2x.glRenderbufferStorageMultisample(36161, this.numSamples, 33190, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.glDepthBuffer[0]);
                    this.gl.glGenRenderbuffers(1, this.glStencilBuffer, 0);
                    this.gl.glBindRenderbuffer(36161, this.glStencilBuffer[0]);
                    this.gl2x.glRenderbufferStorageMultisample(36161, this.numSamples, 36168, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36128, 36161, this.glStencilBuffer[0]);
                }
                this.validateFramebuffer();
                this.gl.glClearDepth(1.0);
                this.gl.glClearStencil(0);
                this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                this.gl.glClear(17664);
                this.gl.glBindFramebuffer(36160, this.glColorFbo[0]);
            } else {
                if (this.packedDepthStencil) {
                    this.gl.glGenRenderbuffers(1, this.glPackedDepthStencil, 0);
                    this.gl.glBindRenderbuffer(36161, this.glPackedDepthStencil[0]);
                    this.gl.glRenderbufferStorage(36161, 35056, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.glPackedDepthStencil[0]);
                    this.gl.glFramebufferRenderbuffer(36160, 36128, 36161, this.glPackedDepthStencil[0]);
                } else {
                    this.gl.glGenRenderbuffers(1, this.glDepthBuffer, 0);
                    this.gl.glBindRenderbuffer(36161, this.glDepthBuffer[0]);
                    this.gl.glRenderbufferStorage(36161, 33190, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.glDepthBuffer[0]);
                    this.gl.glGenRenderbuffers(1, this.glStencilBuffer, 0);
                    this.gl.glBindRenderbuffer(36161, this.glStencilBuffer[0]);
                    this.gl.glRenderbufferStorage(36161, 36168, this.fboWidth, this.fboHeight);
                    this.gl.glFramebufferRenderbuffer(36160, 36128, 36161, this.glStencilBuffer[0]);
                }
                this.validateFramebuffer();
                this.gl.glClearDepth(1.0);
                this.gl.glClearStencil(0);
                this.gl.glClear(1280);
            }
            PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
            this.backTex = 1;
            this.frontTex = 0;
        } else {
            PGraphicsOpenGL.screenFramebuffer.glFbo = 0;
        }
    }

    protected void updateOffscreen(PGL primary) {
        this.gl = primary.gl;
        this.gl2 = primary.gl2;
        this.gl2x = primary.gl2x;
    }

    protected int primaryDrawBuffer() {
        if (this.glColorFbo[0] == 0) {
            return 1029;
        }
        return 36064;
    }

    protected boolean primaryIsFboBacked() {
        return this.glColorFbo[0] != 0;
    }

    protected int getFboTexTarget() {
        return 3553;
    }

    protected int getFboTexName() {
        return this.glColorTex[0];
    }

    protected int getFboWidth() {
        return this.fboWidth;
    }

    protected int getFboHeight() {
        return this.fboHeight;
    }

    protected void bindPrimaryColorFBO() {
        if (this.multisample) {
            this.gl.glBindFramebuffer(36008, this.glMultiFbo[0]);
            this.gl.glBindFramebuffer(36009, this.glColorFbo[0]);
            this.gl2x.glBlitFramebuffer(0, 0, this.fboWidth, this.fboHeight, 0, 0, this.fboWidth, this.fboHeight, 16384, 9728);
        }
        this.gl.glBindFramebuffer(36160, this.glColorFbo[0]);
        PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
        this.gl.glColorMask(false, false, false, true);
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.gl.glClear(16384);
        this.gl.glColorMask(true, true, true, true);
    }

    protected void bindPrimaryMultiFBO() {
        if (this.multisample) {
            this.gl.glBindFramebuffer(36160, this.glMultiFbo[0]);
            PGraphicsOpenGL.screenFramebuffer.glFbo = this.glMultiFbo[0];
        }
    }

    protected void releaseScreenFBO() {
        this.gl.glDeleteTextures(1, this.glColorTex, 0);
        this.gl.glDeleteFramebuffers(1, this.glColorFbo, 0);
        if (this.packedDepthStencil) {
            this.gl.glDeleteRenderbuffers(1, this.glPackedDepthStencil, 0);
        } else {
            this.gl.glDeleteRenderbuffers(1, this.glDepthBuffer, 0);
            this.gl.glDeleteRenderbuffers(1, this.glStencilBuffer, 0);
        }
        if (this.multisample) {
            this.gl.glDeleteFramebuffers(1, this.glMultiFbo, 0);
            this.gl.glDeleteRenderbuffers(1, this.glColorRenderBuffer, 0);
        }
    }

    protected int qualityToSamples(int quality) {
        if (quality <= 1) {
            return 1;
        }
        int n = 2 * (quality / 2);
        return n;
    }

    protected void bindBackBufferTex() {
        if (!this.texturingIsEnabled(3553)) {
            this.enableTexturing(3553);
        }
        this.gl.glBindTexture(3553, this.glColorTex[this.backTex]);
    }

    protected void unbindBackBufferTex() {
        if (this.textureIsBound(3553, this.glColorTex[this.backTex])) {
            if (!this.texturingIsEnabled(3553)) {
                this.enableTexturing(3553);
                this.gl.glBindTexture(3553, 0);
                this.disableTexturing(3553);
            } else {
                this.gl.glBindTexture(3553, 0);
            }
        }
    }

    protected void beginOnscreenDraw(boolean clear) {
        if (this.glColorFbo[0] != 0) {
            this.gl.glBindFramebuffer(36160, this.glColorFbo[0]);
            this.gl.glFramebufferTexture2D(36160, 36064, 3553, this.glColorTex[this.frontTex], 0);
            if (this.multisample) {
                this.gl.glBindFramebuffer(36160, this.glMultiFbo[0]);
                this.gl2x.glDrawBuffer(36064);
                PGraphicsOpenGL.screenFramebuffer.glFbo = this.glMultiFbo[0];
            } else {
                if (this.gl2x != null) {
                    this.gl2x.glDrawBuffer(36064);
                }
                PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
            }
        }
    }

    protected void endOnscreenDraw(boolean clear0) {
        if (this.glColorFbo[0] != 0) {
            if (this.multisample) {
                this.gl.glBindFramebuffer(36008, this.glMultiFbo[0]);
                this.gl.glBindFramebuffer(36009, this.glColorFbo[0]);
                this.gl2x.glBlitFramebuffer(0, 0, this.fboWidth, this.fboHeight, 0, 0, this.fboWidth, this.fboHeight, 16384, 9728);
            }
            this.gl.glBindFramebuffer(36160, 0);
            this.gl.glClearDepth(1.0);
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glClear(1280);
            this.gl.glDisable(3042);
            this.drawTexture(3553, this.glColorTex[this.frontTex], this.fboWidth, this.fboHeight, 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            this.gl.glBindFramebuffer(36160, this.glColorFbo[0]);
            PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
        }
    }

    protected void beginOffscreenDraw(boolean clear) {
    }

    protected void endOffscreenDraw(boolean clear0) {
    }

    protected boolean canDraw() {
        return this.initialized && this.pg.parent.isDisplayable();
    }

    protected void requestDraw() {
        if (this.initialized) {
            try {
                if (toolkit == 0) {
                    this.canvasAWT.display();
                } else if (toolkit == 1) {
                    this.animator.requestDisplay();
                }
            }
            catch (GLException e) {
                Throwable tr = e.getCause();
                throw (RuntimeException)tr;
            }
        }
    }

    public String getString(int name) {
        return this.gl.glGetString(name);
    }

    public void getIntegerv(int name, int[] values, int offset) {
        this.gl.glGetIntegerv(name, values, offset);
    }

    public void getBooleanv(int name, boolean[] values, int offset) {
        if (-1 < name) {
            byte[] bvalues = new byte[values.length];
            this.gl.glGetBooleanv(name, bvalues, offset);
            for (int i = 0; i < values.length; ++i) {
                values[i] = bvalues[i] != 0;
            }
        } else {
            Arrays.fill(values, false);
        }
    }

    public void enable(int cap) {
        if (-1 < cap) {
            this.gl.glEnable(cap);
        }
    }

    public void disable(int cap) {
        if (-1 < cap) {
            this.gl.glDisable(cap);
        }
    }

    public void flush() {
        this.gl.glFlush();
    }

    public void finish() {
        this.gl.glFinish();
    }

    public int getError() {
        return this.gl.glGetError();
    }

    public String errorString(int err) {
        return this.glu.gluErrorString(err);
    }

    public void frontFace(int mode) {
        this.gl.glFrontFace(mode);
    }

    public void cullFace(int mode) {
        this.gl.glCullFace(mode);
    }

    public void depthMask(boolean flag) {
        this.gl.glDepthMask(flag);
    }

    public void depthFunc(int func) {
        this.gl.glDepthFunc(func);
    }

    public void genTextures(int n, int[] ids, int offset) {
        this.gl.glGenTextures(n, ids, offset);
    }

    public void deleteTextures(int n, int[] ids, int offset) {
        this.gl.glDeleteTextures(n, ids, offset);
    }

    public void activeTexture(int unit) {
        this.gl.glActiveTexture(unit);
    }

    public void bindTexture(int target, int id) {
        this.gl.glBindTexture(target, id);
        if (target == 3553) {
            PGL.boundTextures[0] = id;
        } else if (target == 34037) {
            PGL.boundTextures[1] = id;
        }
    }

    public void texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, Buffer data) {
        this.gl.glTexImage2D(target, level, internalFormat, width, height, border, format, type, data);
    }

    public void texSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int type, Buffer data) {
        this.gl.glTexSubImage2D(target, level, xOffset, yOffset, width, height, format, type, data);
    }

    public void texParameteri(int target, int param, int value) {
        this.gl.glTexParameteri(target, param, value);
    }

    public void getTexParameteriv(int target, int param, int[] values, int offset) {
        this.gl.glGetTexParameteriv(target, param, values, offset);
    }

    public void generateMipmap(int target) {
        this.gl.glGenerateMipmap(target);
    }

    public void genBuffers(int n, int[] ids, int offset) {
        this.gl.glGenBuffers(n, ids, offset);
    }

    public void deleteBuffers(int n, int[] ids, int offset) {
        this.gl.glDeleteBuffers(n, ids, offset);
    }

    public void bindBuffer(int target, int id) {
        this.gl.glBindBuffer(target, id);
    }

    public void bufferData(int target, int size, Buffer data, int usage) {
        this.gl.glBufferData(target, size, data, usage);
    }

    public void bufferSubData(int target, int offset, int size, Buffer data) {
        this.gl.glBufferSubData(target, offset, size, data);
    }

    public void drawArrays(int mode, int first, int count) {
        this.gl.glDrawArrays(mode, first, count);
    }

    public void drawElements(int mode, int count, int type, int offset) {
        this.gl.glDrawElements(mode, count, type, offset);
    }

    public void enableVertexAttribArray(int loc) {
        this.gl2.glEnableVertexAttribArray(loc);
    }

    public void disableVertexAttribArray(int loc) {
        this.gl2.glDisableVertexAttribArray(loc);
    }

    public void vertexAttribPointer(int loc, int size, int type, boolean normalized, int stride, int offset) {
        this.gl2.glVertexAttribPointer(loc, size, type, normalized, stride, offset);
    }

    public void vertexAttribPointer(int loc, int size, int type, boolean normalized, int stride, Buffer data) {
        this.gl2.glVertexAttribPointer(loc, size, type, normalized, stride, data);
    }

    public ByteBuffer mapBuffer(int target, int access) {
        return this.gl2.glMapBuffer(target, access);
    }

    public ByteBuffer mapBufferRange(int target, int offset, int length, int access) {
        if (this.gl2x != null) {
            return this.gl2x.glMapBufferRange(target, offset, length, access);
        }
        return null;
    }

    public void unmapBuffer(int target) {
        this.gl2.glUnmapBuffer(target);
    }

    public void genFramebuffers(int n, int[] ids, int offset) {
        this.gl.glGenFramebuffers(n, ids, offset);
    }

    public void deleteFramebuffers(int n, int[] ids, int offset) {
        this.gl.glDeleteFramebuffers(n, ids, offset);
    }

    public void genRenderbuffers(int n, int[] ids, int offset) {
        this.gl.glGenRenderbuffers(n, ids, offset);
    }

    public void deleteRenderbuffers(int n, int[] ids, int offset) {
        this.gl.glDeleteRenderbuffers(n, ids, offset);
    }

    public void bindFramebuffer(int target, int id) {
        this.gl.glBindFramebuffer(target, id);
    }

    public void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        if (this.gl2x != null) {
            this.gl2x.glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
        }
    }

    public void framebufferTexture2D(int target, int attachment, int texTarget, int texId, int level) {
        this.gl.glFramebufferTexture2D(target, attachment, texTarget, texId, level);
    }

    public void bindRenderbuffer(int target, int id) {
        this.gl.glBindRenderbuffer(target, id);
    }

    public void renderbufferStorageMultisample(int target, int samples, int format, int width, int height) {
        if (this.gl2x != null) {
            this.gl2x.glRenderbufferStorageMultisample(target, samples, format, width, height);
        }
    }

    public void renderbufferStorage(int target, int format, int width, int height) {
        this.gl.glRenderbufferStorage(target, format, width, height);
    }

    public void framebufferRenderbuffer(int target, int attachment, int rendbufTarget, int rendbufId) {
        this.gl.glFramebufferRenderbuffer(target, attachment, rendbufTarget, rendbufId);
    }

    public int checkFramebufferStatus(int target) {
        return this.gl.glCheckFramebufferStatus(target);
    }

    public int createProgram() {
        return this.gl2.glCreateProgram();
    }

    public void deleteProgram(int id) {
        this.gl2.glDeleteProgram(id);
    }

    public int createShader(int type) {
        return this.gl2.glCreateShader(type);
    }

    public void deleteShader(int id) {
        this.gl2.glDeleteShader(id);
    }

    public void linkProgram(int prog) {
        this.gl2.glLinkProgram(prog);
    }

    public void validateProgram(int prog) {
        this.gl2.glValidateProgram(prog);
    }

    public void useProgram(int prog) {
        this.gl2.glUseProgram(prog);
    }

    public int getAttribLocation(int prog, String name) {
        return this.gl2.glGetAttribLocation(prog, name);
    }

    public int getUniformLocation(int prog, String name) {
        return this.gl2.glGetUniformLocation(prog, name);
    }

    public void uniform1i(int loc, int value) {
        this.gl2.glUniform1i(loc, value);
    }

    public void uniform2i(int loc, int value0, int value1) {
        this.gl2.glUniform2i(loc, value0, value1);
    }

    public void uniform3i(int loc, int value0, int value1, int value2) {
        this.gl2.glUniform3i(loc, value0, value1, value2);
    }

    public void uniform4i(int loc, int value0, int value1, int value2, int value3) {
        this.gl2.glUniform4i(loc, value0, value1, value2, value3);
    }

    public void uniform1f(int loc, float value) {
        this.gl2.glUniform1f(loc, value);
    }

    public void uniform2f(int loc, float value0, float value1) {
        this.gl2.glUniform2f(loc, value0, value1);
    }

    public void uniform3f(int loc, float value0, float value1, float value2) {
        this.gl2.glUniform3f(loc, value0, value1, value2);
    }

    public void uniform4f(int loc, float value0, float value1, float value2, float value3) {
        this.gl2.glUniform4f(loc, value0, value1, value2, value3);
    }

    public void uniform1iv(int loc, int count, int[] v, int offset) {
        this.gl2.glUniform1iv(loc, count, v, offset);
    }

    public void uniform2iv(int loc, int count, int[] v, int offset) {
        this.gl2.glUniform2iv(loc, count, v, offset);
    }

    public void uniform3iv(int loc, int count, int[] v, int offset) {
        this.gl2.glUniform3iv(loc, count, v, offset);
    }

    public void uniform4iv(int loc, int count, int[] v, int offset) {
        this.gl2.glUniform4iv(loc, count, v, offset);
    }

    public void uniform1fv(int loc, int count, float[] v, int offset) {
        this.gl2.glUniform1fv(loc, count, v, offset);
    }

    public void uniform2fv(int loc, int count, float[] v, int offset) {
        this.gl2.glUniform2fv(loc, count, v, offset);
    }

    public void uniform3fv(int loc, int count, float[] v, int offset) {
        this.gl2.glUniform3fv(loc, count, v, offset);
    }

    public void uniform4fv(int loc, int count, float[] v, int offset) {
        this.gl2.glUniform4fv(loc, count, v, offset);
    }

    public void uniformMatrix2fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        this.gl2.glUniformMatrix2fv(loc, count, transpose, mat, offset);
    }

    public void uniformMatrix3fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        this.gl2.glUniformMatrix3fv(loc, count, transpose, mat, offset);
    }

    public void uniformMatrix4fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        this.gl2.glUniformMatrix4fv(loc, count, transpose, mat, offset);
    }

    public void vertexAttrib1f(int loc, float value) {
        this.gl2.glVertexAttrib1f(loc, value);
    }

    public void vertexAttrib2f(int loc, float value0, float value1) {
        this.gl2.glVertexAttrib2f(loc, value0, value1);
    }

    public void vertexAttrib3f(int loc, float value0, float value1, float value2) {
        this.gl2.glVertexAttrib3f(loc, value0, value1, value2);
    }

    public void vertexAttrib4f(int loc, float value0, float value1, float value2, float value3) {
        this.gl2.glVertexAttrib4f(loc, value0, value1, value2, value3);
    }

    public void vertexAttrib1fv(int loc, float[] v, int offset) {
        this.gl2.glVertexAttrib1fv(loc, v, offset);
    }

    public void vertexAttrib2fv(int loc, float[] v, int offset) {
        this.gl2.glVertexAttrib2fv(loc, v, offset);
    }

    public void vertexAttrib3fv(int loc, float[] v, int offset) {
        this.gl2.glVertexAttrib3fv(loc, v, offset);
    }

    public void vertexAttrib4fv(int loc, float[] v, int offset) {
        this.gl2.glVertexAttrib4fv(loc, v, offset);
    }

    public void shaderSource(int id, String source) {
        this.gl2.glShaderSource(id, 1, new String[]{source}, null, 0);
    }

    public void compileShader(int id) {
        this.gl2.glCompileShader(id);
    }

    public void attachShader(int prog, int shader) {
        this.gl2.glAttachShader(prog, shader);
    }

    public void getShaderiv(int shader, int pname, int[] params, int offset) {
        this.gl2.glGetShaderiv(shader, pname, params, offset);
    }

    public String getShaderInfoLog(int shader) {
        int[] val = new int[]{0};
        this.gl2.glGetShaderiv(shader, 35716, val, 0);
        int length = val[0];
        byte[] log = new byte[length];
        this.gl2.glGetShaderInfoLog(shader, length, val, 0, log, 0);
        return new String(log);
    }

    public void getProgramiv(int prog, int pname, int[] params, int offset) {
        this.gl2.glGetProgramiv(prog, pname, params, offset);
    }

    public String getProgramInfoLog(int prog) {
        int[] val = new int[]{0};
        this.gl2.glGetShaderiv(prog, 35716, val, 0);
        int length = val[0];
        byte[] log = new byte[length];
        this.gl2.glGetProgramInfoLog(prog, length, val, 0, log, 0);
        return new String(log);
    }

    public void viewport(int x, int y, int width, int height) {
        this.gl.glViewport(x, y, width, height);
    }

    public void scissor(int x, int y, int w, int h) {
        this.gl.glScissor(x, y, w, h);
    }

    public void blendEquation(int eq) {
        this.gl.glBlendEquation(eq);
    }

    public void blendFunc(int srcFactor, int dstFactor) {
        this.gl.glBlendFunc(srcFactor, dstFactor);
    }

    public void readBuffer(int buf) {
        if (this.gl2x != null) {
            this.gl2x.glReadBuffer(buf);
        }
    }

    public void readPixels(int x, int y, int width, int height, int format, int type, Buffer buffer) {
        this.gl.glReadPixels(x, y, width, height, format, type, buffer);
    }

    public void drawBuffer(int buf) {
        if (this.gl2x != null) {
            this.gl2x.glDrawBuffer(buf);
        }
    }

    public void clearDepth(float d) {
        this.gl.glClearDepthf(d);
    }

    public void clearStencil(int s) {
        this.gl.glClearStencil(s);
    }

    public void colorMask(boolean wr, boolean wg, boolean wb, boolean wa) {
        this.gl.glColorMask(wr, wg, wb, wa);
    }

    public void clearColor(float r, float g, float b, float a) {
        this.gl.glClearColor(r, g, b, a);
    }

    public void clear(int mask) {
        this.gl.glClear(mask);
    }

    protected Context createEmptyContext() {
        return new Context();
    }

    protected Context getCurrentContext() {
        return new Context(this.context);
    }

    protected Tessellator createTessellator(TessellatorCallback callback) {
        return new Tessellator(callback);
    }

    protected String tessError(int err) {
        return this.glu.gluErrorString(err);
    }

    protected boolean contextIsCurrent(Context other) {
        return other == null || other.current();
    }

    protected void enableTexturing(int target) {
        this.enable(target);
        if (target == 3553) {
            PGL.texturingTargets[0] = true;
        } else if (target == 34037) {
            PGL.texturingTargets[1] = true;
        }
    }

    protected void disableTexturing(int target) {
        this.disable(target);
        if (target == 3553) {
            PGL.texturingTargets[0] = false;
        } else if (target == 34037) {
            PGL.texturingTargets[1] = false;
        }
    }

    protected boolean texturingIsEnabled(int target) {
        if (target == 3553) {
            return texturingTargets[0];
        }
        if (target == 34037) {
            return texturingTargets[1];
        }
        return false;
    }

    protected boolean textureIsBound(int target, int id) {
        if (target == 3553) {
            return boundTextures[0] == id;
        }
        if (target == 34037) {
            return boundTextures[1] == id;
        }
        return false;
    }

    protected void initTexture(int target, int format, int width, int height) {
        int[] texels = new int[width * height];
        this.texSubImage2D(target, 0, 0, 0, width, height, format, 5121, IntBuffer.wrap(texels));
    }

    protected void copyToTexture(int target, int format, int id, int x, int y, int w, int h, IntBuffer buffer) {
        this.activeTexture(33984);
        boolean enabledTex = false;
        if (!this.texturingIsEnabled(target)) {
            this.enableTexturing(target);
            enabledTex = true;
        }
        this.bindTexture(target, id);
        this.texSubImage2D(target, 0, x, y, w, h, format, 5121, buffer);
        this.bindTexture(target, 0);
        if (enabledTex) {
            this.disableTexturing(target);
        }
    }

    protected void drawTexture(int target, int id, int width, int height, int X0, int Y0, int X1, int Y1) {
        this.drawTexture(target, id, width, height, X0, Y0, X1, Y1, X0, Y0, X1, Y1);
    }

    protected void drawTexture(int target, int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (target == 3553) {
            this.drawTexture2D(id, width, height, texX0, texY0, texX1, texY1, scrX0, scrY0, scrX1, scrY1);
        } else if (target == 34037) {
            this.drawTextureRect(id, width, height, texX0, texY0, texX1, texY1, scrX0, scrY0, scrX1, scrY1);
        }
    }

    protected void drawTexture2D(int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (!this.loadedTex2DShader || this.tex2DShaderContext.hashCode() != this.context.hashCode()) {
            this.tex2DVertShader = this.createShader(35633, this.texVertShaderSource);
            this.tex2DFragShader = this.createShader(35632, this.tex2DFragShaderSource);
            if (0 < this.tex2DVertShader && 0 < this.tex2DFragShader) {
                this.tex2DShaderProgram = this.createProgram(this.tex2DVertShader, this.tex2DFragShader);
            }
            if (0 < this.tex2DShaderProgram) {
                this.tex2DVertLoc = this.getAttribLocation(this.tex2DShaderProgram, "inVertex");
                this.tex2DTCoordLoc = this.getAttribLocation(this.tex2DShaderProgram, "inTexcoord");
            }
            this.loadedTex2DShader = true;
            this.tex2DShaderContext = this.context;
        }
        if (this.texData == null) {
            this.texData = PGL.allocateDirectFloatBuffer(this.texCoords.length);
        }
        if (0 < this.tex2DShaderProgram) {
            boolean[] depthTest = new boolean[1];
            this.getBooleanv(2929, depthTest, 0);
            this.disable(2929);
            boolean[] depthMask = new boolean[1];
            this.getBooleanv(2930, depthMask, 0);
            this.depthMask(false);
            this.useProgram(this.tex2DShaderProgram);
            this.enableVertexAttribArray(this.tex2DVertLoc);
            this.enableVertexAttribArray(this.tex2DTCoordLoc);
            this.texCoords[0] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.texCoords[1] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.texCoords[2] = (float)texX0 / (float)width;
            this.texCoords[3] = (float)texY0 / (float)height;
            this.texCoords[4] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.texCoords[5] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.texCoords[6] = (float)texX1 / (float)width;
            this.texCoords[7] = (float)texY0 / (float)height;
            this.texCoords[8] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.texCoords[9] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.texCoords[10] = (float)texX0 / (float)width;
            this.texCoords[11] = (float)texY1 / (float)height;
            this.texCoords[12] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.texCoords[13] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.texCoords[14] = (float)texX1 / (float)width;
            this.texCoords[15] = (float)texY1 / (float)height;
            this.texData.rewind();
            this.texData.put(this.texCoords);
            this.activeTexture(33984);
            boolean enabledTex = false;
            if (!this.texturingIsEnabled(3553)) {
                this.enableTexturing(3553);
                enabledTex = true;
            }
            this.bindTexture(3553, id);
            this.bindBuffer(34962, 0);
            this.texData.position(0);
            this.vertexAttribPointer(this.tex2DVertLoc, 2, 5126, false, 16, this.texData);
            this.texData.position(2);
            this.vertexAttribPointer(this.tex2DTCoordLoc, 2, 5126, false, 16, this.texData);
            this.drawArrays(5, 0, 4);
            this.bindTexture(3553, 0);
            if (enabledTex) {
                this.disableTexturing(3553);
            }
            this.disableVertexAttribArray(this.tex2DVertLoc);
            this.disableVertexAttribArray(this.tex2DTCoordLoc);
            this.useProgram(0);
            if (depthTest[0]) {
                this.enable(2929);
            } else {
                this.disable(2929);
            }
            this.depthMask(depthMask[0]);
        }
    }

    protected void drawTextureRect(int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (!this.loadedTexRectShader || this.texRectShaderContext.hashCode() != this.context.hashCode()) {
            this.texRectVertShader = this.createShader(35633, this.texVertShaderSource);
            this.texRectFragShader = this.createShader(35632, this.texRectFragShaderSource);
            if (0 < this.texRectVertShader && 0 < this.texRectFragShader) {
                this.texRectShaderProgram = this.createProgram(this.texRectVertShader, this.texRectFragShader);
            }
            if (0 < this.texRectShaderProgram) {
                this.texRectVertLoc = this.getAttribLocation(this.texRectShaderProgram, "inVertex");
                this.texRectTCoordLoc = this.getAttribLocation(this.texRectShaderProgram, "inTexcoord");
            }
            this.loadedTexRectShader = true;
            this.texRectShaderContext = this.context;
        }
        if (this.texData == null) {
            this.texData = PGL.allocateDirectFloatBuffer(this.texCoords.length);
        }
        if (0 < this.texRectShaderProgram) {
            boolean[] depthTest = new boolean[1];
            this.getBooleanv(2929, depthTest, 0);
            this.disable(2929);
            boolean[] depthMask = new boolean[1];
            this.getBooleanv(2930, depthMask, 0);
            this.depthMask(false);
            this.useProgram(this.texRectShaderProgram);
            this.enableVertexAttribArray(this.texRectVertLoc);
            this.enableVertexAttribArray(this.texRectTCoordLoc);
            this.texCoords[0] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.texCoords[1] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.texCoords[2] = texX0;
            this.texCoords[3] = texY0;
            this.texCoords[4] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.texCoords[5] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.texCoords[6] = texX1;
            this.texCoords[7] = texY0;
            this.texCoords[8] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.texCoords[9] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.texCoords[10] = texX0;
            this.texCoords[11] = texY1;
            this.texCoords[12] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.texCoords[13] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.texCoords[14] = texX1;
            this.texCoords[15] = texY1;
            this.texData.rewind();
            this.texData.put(this.texCoords);
            this.activeTexture(33984);
            boolean enabledTex = false;
            if (!this.texturingIsEnabled(34037)) {
                this.enableTexturing(34037);
                enabledTex = true;
            }
            this.bindTexture(34037, id);
            this.bindBuffer(34962, 0);
            this.texData.position(0);
            this.vertexAttribPointer(this.texRectVertLoc, 2, 5126, false, 16, this.texData);
            this.texData.position(2);
            this.vertexAttribPointer(this.texRectTCoordLoc, 2, 5126, false, 16, this.texData);
            this.drawArrays(5, 0, 4);
            this.bindTexture(34037, 0);
            if (enabledTex) {
                this.disableTexturing(34037);
            }
            this.disableVertexAttribArray(this.texRectVertLoc);
            this.disableVertexAttribArray(this.texRectTCoordLoc);
            this.useProgram(0);
            if (depthTest[0]) {
                this.enable(2929);
            } else {
                this.disable(2929);
            }
            this.depthMask(depthMask[0]);
        }
    }

    protected int getColorValue(int scrX, int scrY) {
        if (this.colorBuffer == null) {
            this.colorBuffer = IntBuffer.allocate(1);
        }
        this.colorBuffer.rewind();
        this.readPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6408, 5121, this.colorBuffer);
        return this.colorBuffer.get();
    }

    protected float getDepthValue(int scrX, int scrY) {
        if (this.depthBuffer == null) {
            this.depthBuffer = FloatBuffer.allocate(1);
        }
        this.depthBuffer.rewind();
        this.readPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6402, 5126, this.depthBuffer);
        return this.depthBuffer.get(0);
    }

    protected byte getStencilValue(int scrX, int scrY) {
        if (this.stencilBuffer == null) {
            this.stencilBuffer = ByteBuffer.allocate(1);
        }
        this.readPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6401, 5121, this.stencilBuffer);
        return this.stencilBuffer.get(0);
    }

    protected static int nextPowerOfTwo(int val) {
        int ret;
        for (ret = 1; ret < val; ret <<= 1) {
        }
        return ret;
    }

    protected static int nativeToJavaARGB(int color) {
        if (BIG_ENDIAN) {
            return color & 0xFF000000 | color >> 8 & 0xFFFFFF;
        }
        return color & 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void nativeToJavaARGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] >> 8 & 0xFFFFFF;
                        pixels[yindex] = temp & 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = temp & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] >> 8 & 0xFFFFFF;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected static int nativeToJavaRGB(int color) {
        if (BIG_ENDIAN) {
            return color << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void nativeToJavaRGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] >> 8 & 0xFFFFFF;
                        pixels[yindex] = 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = 0xFF000000 | pixels[index] >> 8 & 0xFFFFFF;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected static int javaToNativeARGB(int color) {
        if (BIG_ENDIAN) {
            return color >> 24 & 0xFF | color << 8 & 0xFFFFFF00;
        }
        return color & 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void javaToNativeARGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] >> 24 & 0xFF | pixels[yindex] << 8 & 0xFFFFFF00;
                        pixels[yindex] = temp >> 24 & 0xFF | temp << 8 & 0xFFFFFF00;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = pixels[yindex] & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] >> 24 & 0xFF | pixels[index] << 8 & 0xFFFFFF00;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected static int javaToNativeRGB(int color) {
        if (BIG_ENDIAN) {
            return color << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void javaToNativeRGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            for (int y = 0; y < height / 2; ++y) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] << 8 & 0xFFFFFF00 | 0xFF;
                        pixels[yindex] = temp << 8 & 0xFFFFFF00 | 0xFF;
                        ++index;
                        ++yindex;
                    }
                } else {
                    for (x2 = 0; x2 < width; ++x2) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                    }
                }
                yindex -= width * 2;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                for (x = 0; x < width; ++x) {
                    pixels[index] = pixels[index] << 8 & 0xFFFFFF00 | 0xFF;
                    ++index;
                }
            } else {
                for (x = 0; x < width; ++x) {
                    pixels[index] = 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                }
            }
        }
    }

    protected int createShader(int shaderType, String source) {
        int shader = this.createShader(shaderType);
        if (shader != 0) {
            this.shaderSource(shader, source);
            this.compileShader(shader);
            int[] compiled = new int[1];
            this.getShaderiv(shader, 35713, compiled, 0);
            if (compiled[0] == 0) {
                System.err.println("Could not compile shader " + shaderType + ":");
                System.err.println(this.getShaderInfoLog(shader));
                this.deleteShader(shader);
                shader = 0;
            }
        }
        return shader;
    }

    protected int createProgram(int vertexShader, int fragmentShader) {
        int program = this.createProgram();
        if (program != 0) {
            this.attachShader(program, vertexShader);
            this.attachShader(program, fragmentShader);
            this.linkProgram(program);
            int[] linked = new int[1];
            this.getProgramiv(program, 35714, linked, 0);
            if (linked[0] == 0) {
                System.err.println("Could not link program: ");
                System.err.println(this.getProgramInfoLog(program));
                this.deleteProgram(program);
                program = 0;
            }
        }
        return program;
    }

    protected boolean validateFramebuffer() {
        int status = this.checkFramebufferStatus(36160);
        if (status == 36053) {
            return true;
        }
        if (status == 36054) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT (" + Integer.toHexString(status) + ")");
        }
        if (status == 36055) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT (" + Integer.toHexString(status) + ")");
        }
        if (status == 36057) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS (" + Integer.toHexString(status) + ")");
        }
        if (status == 36058) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_FORMATS (" + Integer.toHexString(status) + ")");
        }
        if (status == 36061) {
            throw new RuntimeException("GL_FRAMEBUFFER_UNSUPPORTED" + Integer.toHexString(status));
        }
        throw new RuntimeException("unknown framebuffer error (" + Integer.toHexString(status) + ")");
    }

    protected static ByteBuffer allocateDirectByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 1).order(ByteOrder.nativeOrder());
    }

    protected static IntBuffer allocateDirectIntBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    protected static FloatBuffer allocateDirectFloatBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    static {
        float eps = 1.0f;
        while ((double)((float)(1.0 + (double)(eps /= 2.0f) / 2.0)) != 1.0) {
        }
        FLOAT_EPS = eps;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        toolkit = 0;
        texturingTargets = new boolean[]{false, false};
        boundTextures = new int[]{0, 0};
    }

    protected static class PGLAnimator
    extends AnimatorBase {
        private static int count = 0;
        private Timer timer = null;
        private TimerTask task = null;
        private volatile boolean shouldRun;

        @Override
        protected String getBaseName(String prefix) {
            return prefix + "PGLAnimator";
        }

        public PGLAnimator(GLAutoDrawable drawable) {
            if (drawable != null) {
                this.add(drawable);
            }
        }

        public synchronized void requestDisplay() {
            this.shouldRun = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean isStarted() {
            this.stateSync.lock();
            try {
                boolean bl = this.timer != null;
                return bl;
            }
            finally {
                this.stateSync.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean isAnimating() {
            this.stateSync.lock();
            try {
                boolean bl = this.timer != null && this.task != null;
                return bl;
            }
            finally {
                this.stateSync.unlock();
            }
        }

        private void startTask() {
            if (null != this.task) {
                return;
            }
            this.task = new TimerTask(){
                private boolean firstRun = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (this.firstRun) {
                        Thread.currentThread().setName("PGL-RenderQueue-" + count);
                        this.firstRun = false;
                        count++;
                    }
                    if (PGLAnimator.this.shouldRun) {
                        PGLAnimator.this.animThread = Thread.currentThread();
                        PGLAnimator.this.display();
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            PGLAnimator.this.shouldRun = false;
                        }
                    }
                }
            };
            this.fpsCounter.resetFPSCounter();
            this.shouldRun = false;
            this.timer.schedule(this.task, 0L, 1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean start() {
            if (this.timer != null) {
                return false;
            }
            this.stateSync.lock();
            try {
                this.timer = new Timer();
                this.startTask();
            }
            finally {
                this.stateSync.unlock();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean stop() {
            if (this.timer == null) {
                return false;
            }
            this.stateSync.lock();
            try {
                this.shouldRun = false;
                if (null != this.task) {
                    this.task.cancel();
                    this.task = null;
                }
                if (null != this.timer) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.animThread = null;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.stateSync.unlock();
            }
            return true;
        }

        @Override
        public final boolean isPaused() {
            return false;
        }

        @Override
        public synchronized boolean resume() {
            return false;
        }

        @Override
        public synchronized boolean pause() {
            return false;
        }
    }

    protected class PGLListener
    implements GLEventListener {
        protected PGLListener() {
        }

        @Override
        public void display(GLAutoDrawable adrawable) {
            PGL.this.drawable = adrawable;
            PGL.this.context = adrawable.getContext();
            PGL.this.gl = PGL.this.context.getGL();
            PGL.this.gl2 = PGL.this.gl.getGL2ES2();
            try {
                PGL.this.gl2x = PGL.this.gl.getGL2();
            }
            catch (GLException e) {
                PGL.this.gl2x = null;
            }
            PGL.this.pg.parent.handleDraw();
        }

        @Override
        public void dispose(GLAutoDrawable adrawable) {
        }

        @Override
        public void init(GLAutoDrawable adrawable) {
            PGL.this.drawable = adrawable;
            PGL.this.context = adrawable.getContext();
            PGL.this.gl = PGL.this.context.getGL();
            String extensions = PGL.this.gl.glGetString(7939);
            if (-1 == extensions.indexOf("_framebuffer_object")) {
                throw new RuntimeException("No framebuffer objects available");
            }
            if (-1 == extensions.indexOf("_vertex_buffer_object")) {
                throw new RuntimeException("No vertex buffer objects available");
            }
            if (-1 == extensions.indexOf("_vertex_shader")) {
                throw new RuntimeException("No vertex shaders available");
            }
            if (-1 == extensions.indexOf("_fragment_shader")) {
                throw new RuntimeException("No fragment shaders available");
            }
        }

        @Override
        public void reshape(GLAutoDrawable adrawable, int x, int y, int w, int h) {
            PGL.this.drawable = adrawable;
            PGL.this.context = adrawable.getContext();
            if (PGL.this.glColorFbo[0] != 0) {
                PGL.this.glColorFbo[0] = 0;
            }
        }
    }

    protected static interface TessellatorCallback {
        public void begin(int var1);

        public void end();

        public void vertex(Object var1);

        public void combine(double[] var1, Object[] var2, float[] var3, Object[] var4);

        public void error(int var1);
    }

    protected class Tessellator {
        protected GLUtessellator tess;
        protected TessellatorCallback callback;
        protected GLUCallback gluCallback;

        public Tessellator(TessellatorCallback callback) {
            this.callback = callback;
            this.tess = GLU.gluNewTess();
            this.gluCallback = new GLUCallback();
            GLU.gluTessCallback(this.tess, 100100, this.gluCallback);
            GLU.gluTessCallback(this.tess, 100102, this.gluCallback);
            GLU.gluTessCallback(this.tess, 100101, this.gluCallback);
            GLU.gluTessCallback(this.tess, 100105, this.gluCallback);
            GLU.gluTessCallback(this.tess, 100103, this.gluCallback);
        }

        public void beginPolygon() {
            GLU.gluTessBeginPolygon(this.tess, null);
        }

        public void endPolygon() {
            GLU.gluTessEndPolygon(this.tess);
        }

        public void setWindingRule(int rule) {
            GLU.gluTessProperty(this.tess, 100140, rule);
        }

        public void beginContour() {
            GLU.gluTessBeginContour(this.tess);
        }

        public void endContour() {
            GLU.gluTessEndContour(this.tess);
        }

        public void addVertex(double[] v) {
            GLU.gluTessVertex(this.tess, v, 0, v);
        }

        protected class GLUCallback
        extends GLUtessellatorCallbackAdapter {
            protected GLUCallback() {
            }

            @Override
            public void begin(int type) {
                Tessellator.this.callback.begin(type);
            }

            @Override
            public void end() {
                Tessellator.this.callback.end();
            }

            @Override
            public void vertex(Object data) {
                Tessellator.this.callback.vertex(data);
            }

            @Override
            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                Tessellator.this.callback.combine(coords, data, weight, outData);
            }

            @Override
            public void error(int errnum) {
                Tessellator.this.callback.error(errnum);
            }
        }
    }

    protected class Context {
        protected int id;

        Context() {
            this.id = -1;
        }

        Context(GLContext context) {
            this.id = context != null ? context.hashCode() : -1;
        }

        boolean current() {
            return this.equal(PGL.this.context);
        }

        boolean equal(GLContext context) {
            if (this.id == -1 || context == null) {
                return true;
            }
            return this.id == context.hashCode();
        }

        int id() {
            return this.id;
        }
    }
}

