/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.util;

import madparker.gametools.util.GameElement;

public class StepTimer
extends GameElement {
    protected long begin;
    protected long end;
    protected long interval;
    protected long lastCheck;
    protected long lastInterval;
    public boolean active = false;
    protected long currentTime;

    public StepTimer(long interval, long length) {
        this.interval = interval;
        this.end = length;
    }

    public void trigger() {
        this.active = true;
        this.lastInterval = this.begin = 0L;
        this.currentTime = 0L;
        this.executeBegin();
    }

    @Override
    public void update() {
        this.currentTime += (long)pApplet.millis();
        if (this.currentTime > this.end) {
            this.active = false;
            this.executeEnd();
        }
        if (this.active && this.currentTime > this.begin && this.currentTime >= this.lastInterval + this.interval) {
            this.executeStep();
            this.lastInterval = this.currentTime;
        }
        this.lastCheck = this.currentTime;
    }

    public long getElapsed() {
        return this.lastCheck - this.begin;
    }

    public long getRemaining() {
        return this.end - this.lastCheck;
    }

    protected void executeBegin() {
    }

    protected void executeStep() {
    }

    protected void executeEnd() {
    }

    public long getBegin() {
        return this.begin;
    }

    public long getEnd() {
        return this.end;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isActive() {
        return this.active;
    }

    public void deactivate() {
        this.executeEnd();
        this.active = false;
    }
}

