/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.sprite;

import java.util.ArrayList;
import java.util.List;
import madparker.gametools.sprite.Sprite;
import madparker.gametools.util.GameElement;
import processing.core.PImage;

public class AnimatedSprite
extends Sprite {
    protected int rows;
    protected int columns;
    protected int currentFrame;
    protected int startFrame;
    protected int endFrame;
    protected long prevFrameTime;
    protected int rate;
    public static final int MODE_LOOP = 0;
    public static final int MODE_PING_PONG = 1;
    protected int direction = 1;
    public int animationMode;
    public List<PImage> frames = new ArrayList<PImage>();

    public AnimatedSprite(String imgStr, float x, float y, int rows, int columns, int rate) {
        super(imgStr, x, y);
        this.rows = rows;
        this.columns = columns;
        this.startFrame = 0;
        this.endFrame = rows * columns - 1;
        this.spriteWidth = this.pImage.width / columns;
        this.spriteHeight = this.pImage.height / rows;
        this.rate = rate;
        int i = 0;
        while (i < rows * columns) {
            this.frames.add(i, this.pImage.get(i % columns * this.spriteWidth, i / columns * this.spriteHeight, this.spriteWidth, this.spriteHeight));
            ++i;
        }
        this.currentFrame = this.startFrame;
        this.prevFrameTime = GameElement.currentTime;
    }

    public AnimatedSprite(String imgStr, float x, float y, int rows, int columns, int rate, int startFrame, int endFrame) {
        super(imgStr, x, y);
        this.rows = rows;
        this.columns = columns;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
        this.spriteWidth = this.pImage.width / columns;
        this.spriteHeight = this.pImage.height / rows;
        this.rate = rate;
        this.currentFrame = startFrame;
        this.prevFrameTime = currentTime;
    }

    public void changeAnimation(int startFrame, int endFrame) {
        this.startFrame = startFrame;
        this.endFrame = endFrame;
        this.currentFrame = startFrame;
    }

    @Override
    public void update() {
        super.update();
        if (currentTime - this.prevFrameTime > (long)(1000 / this.rate)) {
            this.increment();
            this.prevFrameTime = currentTime;
        }
        if (this.currentFrame >= this.endFrame) {
            if (this.animationMode == 0) {
                this.currentFrame = this.startFrame;
            } else {
                this.currentFrame = this.endFrame;
                this.direction = -1;
            }
        }
        if (this.currentFrame == this.startFrame && this.direction < 0) {
            this.direction = 1;
        }
        if (this.currentFrame < this.startFrame) {
            this.currentFrame = this.startFrame;
        }
    }

    public void increment() {
        if (this.animationMode == 0) {
            ++this.currentFrame;
        } else if (this.animationMode == 1) {
            this.currentFrame += this.direction;
        }
    }

    @Override
    public void draw() {
        PImage pImg = this.frames.get(this.currentFrame);
        pApplet.pushMatrix();
        pApplet.translate(this.position.x, this.position.y);
        if (this.flip) {
            pApplet.scale(-1.0f, 1.0f);
            pApplet.image(pImg, -pImg.width, 0.0f);
        } else {
            pApplet.image(pImg, 0.0f, 0.0f);
        }
        pApplet.popMatrix();
    }
}

