/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.screen.sceneGraph.ui;

import java.util.Map;
import madparker.gametools.screen.sceneGraph.SceneGraphElement;
import madparker.gametools.screen.sceneGraph.ui.TextElement;
import processing.core.PVector;

public class TextElementGroup
extends SceneGraphElement {
    private int width;
    private int height;
    private int numberOfRows;
    private int fontSize = 14;
    protected TextElement title;
    protected TextElement[] info;
    private boolean dragging;
    private PVector mousePos;
    private String fontPathString;

    public TextElementGroup() {
        this(0.0f, 0.0f, 100, 100, 4, 14, 0, "");
        this.setup();
    }

    public TextElementGroup(float x, float y, String fontPathString) {
        this(x, y, 100, 100, 4, 14, 0, fontPathString);
        this.setup();
    }

    public TextElementGroup(float x, float y, int width, int height, String fontPathString) {
        this(x, y, width, height, 4, 14, 0, fontPathString);
        this.setup();
    }

    public TextElementGroup(float x, float y, int width, int height, int rows, int fontSize, int backgroundColor, String fontPathString) {
        this.position.set(x, y, 0.0f);
        this.width = width;
        this.height = height;
        this.numberOfRows = rows;
        this.fontSize = fontSize;
        this.color = backgroundColor;
        this.fontPathString = fontPathString;
        this.setup();
    }

    @Override
    public void setup() {
        super.setup();
        this.info = new TextElement[this.numberOfRows];
        this.title = new TextElement(this.fontPathString, "TITLE", this.localWorldOffset.x - 0.0f, this.localWorldOffset.y - (float)(this.height / 2) + 10.0f, this.fontSize, pApplet.color(255));
        this.title.setCentered();
        this.addChildren.add(this.title);
        int titleGap = 30;
        int i = 0;
        while (i < this.numberOfRows) {
            this.info[i] = new TextElement(this.fontPathString, "INFO", this.localWorldOffset.x - (float)(this.width / 2) + 10.0f, this.localWorldOffset.y - (float)(this.height / 2) + (float)titleGap + (float)((this.height - titleGap) / this.numberOfRows * i), this.fontSize, pApplet.color(255));
            this.info[i].setTopLeft();
            this.addChildren.add(this.info[i]);
            ++i;
        }
    }

    public void updateTitle(String title) {
        this.title.updateText(title);
    }

    public void updateInfo(int which, String newText) {
        this.info[which].updateText(newText);
    }

    public void updateInfo(int[] statArray) {
        int i = 0;
        while (i < this.info.length) {
            if (i < statArray.length) {
                this.info[i].updateText(statArray[i]);
            } else {
                this.info[i].updateText("");
            }
            ++i;
        }
    }

    public void updateInfo(Map<String, Integer> statMap) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("updateInfo with Map not implemented");
    }

    public void clearInfo() {
        int i = 0;
        while (i < this.info.length) {
            this.info[i].updateText("");
            ++i;
        }
    }

    @Override
    public void draw() {
        super.draw();
        pApplet.pushStyle();
        pApplet.rectMode(3);
        pApplet.fill(this.color);
        pApplet.rect(0.0f, 0.0f, this.width, this.height);
        pApplet.popStyle();
    }

    private boolean mouseOver() {
        return (float)TextElementGroup.pApplet.mouseX > this.position.x - (float)(this.width / 2) + this.parent.localWorldOffset.x && (float)TextElementGroup.pApplet.mouseX < this.position.x + (float)(this.width / 2) + this.parent.localWorldOffset.x && (float)TextElementGroup.pApplet.mouseY > this.position.y - (float)(this.height / 2) + this.parent.localWorldOffset.y && (float)TextElementGroup.pApplet.mouseY < this.position.y + (float)(this.height / 2) + this.parent.localWorldOffset.y;
    }

    @Override
    public void mousePressed() {
        super.mousePressed();
    }

    @Override
    public void mouseReleased() {
        super.mouseReleased();
    }

    @Override
    public void mouseDragged() {
        super.mouseDragged();
        if (this.mouseOver()) {
            this.mousePos = new PVector(TextElementGroup.pApplet.mouseX, TextElementGroup.pApplet.mouseY);
            this.position.set(this.mousePos);
        }
    }
}

