/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.screen.sceneGraph.ui;

import madparker.gametools.screen.sceneGraph.SceneGraphElement;
import processing.core.PFont;
import processing.core.PVector;

public class TextElement
extends SceneGraphElement {
    protected float size;
    protected PFont font;
    public String text;
    protected boolean centered = true;
    protected boolean topLeft = false;
    protected boolean bottomRight = false;

    public TextElement(String fontStr, String text, float x, float y, float size, int color) {
        this.position = new PVector(x, y);
        this.font = pApplet.createFont(fontStr, size);
        this.text = text;
        this.size = size;
        this.color = color;
    }

    @Override
    public void draw() {
        super.draw();
        if (this.centered) {
            pApplet.textAlign(3, 3);
        } else if (this.topLeft) {
            pApplet.textAlign(37, 101);
        } else if (this.bottomRight) {
            pApplet.textAlign(39, 102);
        } else {
            pApplet.textAlign(3, 3);
        }
        pApplet.fill(this.color);
        pApplet.textFont(this.font);
        pApplet.text(this.text, 0.0f, 0.0f);
    }

    public void updateText(String newText) {
        this.text = newText;
    }

    public void updateText(int numericText) {
        this.text = new Integer(numericText).toString();
    }

    public void updateText(float numericText) {
        this.text = new Float(numericText).toString();
    }

    public void setCentered() {
        this.centered = true;
        this.topLeft = false;
        this.bottomRight = false;
    }

    public void setTopLeft() {
        this.topLeft = true;
        this.centered = false;
        this.bottomRight = false;
    }

    public void setBottomRight() {
        this.topLeft = false;
        this.centered = false;
        this.bottomRight = true;
    }
}

