/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.screen.sceneGraph.aefreedman.grid;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import madparker.gametools.screen.sceneGraph.SceneGraphElement;
import madparker.gametools.screen.sceneGraph.aefreedman.grid.GridPosition;
import processing.core.PApplet;
import processing.core.PVector;

public class GridHandler
extends SceneGraphElement {
    protected int totalWidth;
    protected int totalHeight;
    protected int gridSize;
    protected boolean maintainOccupationStatus;
    public List<GridPosition> gridPositions = new ArrayList<GridPosition>();
    protected Set<GridPosition> occupiedGridPosition = new HashSet<GridPosition>();
    protected Set<GridPosition> unoccupiedGridPosition = new HashSet<GridPosition>();

    public GridHandler(int totalWidth, int totalHeight, int gridSize, boolean wrapEdges, boolean diagonalAdjacents, boolean maintainOccupationStatus, int backgroundColor, float colorLerpAmt, float sizeLerpAmt) {
        this.setup(totalWidth, totalHeight, gridSize, wrapEdges, diagonalAdjacents, maintainOccupationStatus, backgroundColor, colorLerpAmt, sizeLerpAmt);
    }

    public GridHandler(int totalWidth, int totalHeight, int gridSize, boolean diagonalAdjacents, boolean maintainOccupationStatus, int backgroundColor, float colorLerpAmt, float sizeLerpAmt) {
        this.setup(totalWidth, totalHeight, gridSize, true, diagonalAdjacents, maintainOccupationStatus, backgroundColor, colorLerpAmt, sizeLerpAmt);
    }

    public void setup(int totalWidth, int totalHeight, int gridSize, boolean wrapEdges, boolean diagonalAdjacents, boolean maintainOccupationStatus, int backgroundColor, float colorLerpAmt, float sizeLerpAmt) {
        super.setup();
        this.position.set(0.0f, 0.0f, 0.0f);
        this.totalHeight = totalHeight;
        this.totalWidth = totalWidth;
        this.gridSize = gridSize;
        this.setupGrid(diagonalAdjacents, backgroundColor, colorLerpAmt, sizeLerpAmt, wrapEdges);
        this.maintainOccupationStatus = maintainOccupationStatus;
    }

    @Override
    public void update() {
        super.update();
        if (this.maintainOccupationStatus) {
            this.unoccupiedGridPosition.removeAll(this.unoccupiedGridPosition);
            this.occupiedGridPosition.removeAll(this.occupiedGridPosition);
            for (GridPosition g : this.gridPositions) {
                if (!g.children.isEmpty()) {
                    this.occupiedGridPosition.add(g);
                    continue;
                }
                this.unoccupiedGridPosition.add(g);
            }
        }
    }

    public GridPosition getRandomUnoccupiedGridPosition() {
        if (!this.unoccupiedGridPosition.isEmpty()) {
            Object[] a = this.unoccupiedGridPosition.toArray();
            return (GridPosition)a[(int)pApplet.random(a.length)];
        }
        PApplet.println("ERROR: Tried to get unoccupied grid position but there wasn't one!");
        return null;
    }

    public boolean isUnoccupiedPositionAvailable() {
        return !this.unoccupiedGridPosition.isEmpty();
    }

    public GridPosition getGridPositionAtPoint(PVector position) {
        int row = (int)Math.floor(position.x / (float)this.gridSize);
        int column = (int)Math.floor(position.y / (float)this.gridSize);
        PVector p = new PVector(row * this.gridSize, column * this.gridSize);
        try {
            for (GridPosition grid : this.gridPositions) {
                if (!((Object)grid.position).equals(p)) continue;
                return grid;
            }
        }
        catch (NullPointerException e) {
            System.out.println("Didn't find a GridPosition @ " + p.x + ", " + p.y);
        }
        return null;
    }

    public GridPosition getGridPositionAtPoint(int x, int y) {
        return this.getGridPositionAtPoint(new PVector(x, y));
    }

    public GridPosition getGridPositionAtIndex(int index) {
        return this.gridPositions.get(index);
    }

    private void setupGrid(boolean diagonalAdjacents, int backgroundColor, float colorLerpAmt, float sizeLerpAmt, boolean wrapEdges) {
        int i = 0;
        while (i < this.totalWidth) {
            int j = 0;
            while (j < this.totalHeight) {
                PVector position = new PVector(i, j);
                GridPosition pos = new GridPosition(position, this, wrapEdges, this.gridSize, sizeLerpAmt, backgroundColor, colorLerpAmt);
                this.gridPositions.add(pos);
                this.children.add(pos);
                this.unoccupiedGridPosition.add(pos);
                j += this.gridSize;
            }
            i += this.gridSize;
        }
        for (GridPosition gridPos : this.gridPositions) {
            gridPos.getAdjacentPositions();
        }
        if (diagonalAdjacents) {
            for (GridPosition gridPos : this.gridPositions) {
                gridPos.getAdjacentDiagonalPositions();
            }
        }
    }

    public void toggleDebugDraw() {
        for (GridPosition gridElement : this.gridPositions) {
            gridElement.setDebugDraw(!gridElement.isDebugDraw());
        }
    }

    public void resetGridAnimation() {
        for (GridPosition gridElement : this.gridPositions) {
            gridElement.resetAnimation();
        }
    }

    public void updateAnimationSpeed(float sizeLerpAmt, float colorLerpAmt) {
        for (GridPosition gridElement : this.gridPositions) {
            gridElement.updateAnimationSpeed(sizeLerpAmt, colorLerpAmt);
        }
    }

    public void notifyPopulated(GridPosition p) {
        this.unoccupiedGridPosition.remove(p);
        this.occupiedGridPosition.add(p);
    }

    public void notifyDepopulated(GridPosition p) {
        this.occupiedGridPosition.remove(p);
        this.unoccupiedGridPosition.add(p);
    }
}

