/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.animation;

import madparker.gametools.animation.ForegroundAnimation;
import processing.core.PApplet;

public abstract class ProgressAnimation
extends ForegroundAnimation {
    protected long duration;
    protected long progress;
    protected float percent;
    public static float speedUp = 1.0f;

    @Override
    public void trigger() {
        super.trigger();
        this.progress = 0L;
        this.percent = 0.0f;
    }

    public void setSpeedUp(float speed) {
        speedUp = speed;
        this.progress = (long)(this.percent * (float)this.duration / speedUp);
    }

    @Override
    public void update() {
        this.progress += this.frameMillis;
        this.percent = PApplet.map(this.progress, 0.0f, (float)this.duration / speedUp, 0.0f, 1.0f);
        if (this.percent > 1.0f) {
            this.percent = 1.0f;
        }
        super.update();
        if (this.isEnd()) {
            activeFgAnimations.remove(this);
            if (activeFgAnimations.size() == 0) {
                activeAnimation = false;
            }
        }
    }

    @Override
    protected void executeEnd() {
        this.percent = 1.0f;
        this.step();
    }

    @Override
    protected boolean isEnd() {
        return this.progress >= this.duration;
    }
}

