/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.animation;

import madparker.gametools.GameTemplate;
import madparker.gametools.animation.ProgressAnimation;
import madparker.gametools.screen.Screen;

public class CrossFadeScreensAnimation
extends ProgressAnimation {
    public GameTemplate game;
    public Screen currentScreen;
    public Screen nextScreen;
    public boolean switchScreens;

    public void trigger(GameTemplate game, Screen currentScreen, Screen nextScreen, int duration) {
        super.trigger();
        this.game = game;
        this.currentScreen = currentScreen;
        this.nextScreen = nextScreen;
        this.duration = duration;
        this.switchScreens = true;
    }

    @Override
    protected void executeBegin() {
    }

    @Override
    protected void step() {
        if (this.percent < 0.5f) {
            this.currentScreen.foregroundFadeAlpha = 255.0f * this.percent * 2.0f;
        } else if (this.switchScreens) {
            this.switchScreens = false;
            this.nextScreen.foregroundFadeAlpha = 255.0f;
            this.nextScreen.setup();
            this.game.currentScreen = this.nextScreen;
        }
        if (!this.switchScreens) {
            this.nextScreen.foregroundFadeAlpha = 255.0f * (1.0f - (this.percent - 0.5f) * 2.0f);
        }
    }

    @Override
    protected void executeEnd() {
        this.currentScreen.foregroundFadeAlpha = 0.0f;
        this.nextScreen.foregroundFadeAlpha = 0.0f;
    }
}

