/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools;

import java.util.ArrayList;
import java.util.List;
import madparker.gametools.animation.ForegroundAnimation;
import madparker.gametools.screen.Screen;
import madparker.gametools.util.GameElement;
import madparker.gametools.util.ProcessingObject;
import madparker.gametools.util.Timer;
import processing.core.PApplet;

public class GameTemplate
extends PApplet {
    public Screen currentScreen;
    public List<Timer> timers;

    @Override
    public void setup() {
        ProcessingObject.pApplet = this;
        GameElement.prevTime = System.currentTimeMillis();
        GameElement.currentTime = System.currentTimeMillis();
        this.timers = new ArrayList<Timer>();
    }

    @Override
    public void draw() {
        GameElement.prevTime = GameElement.currentTime;
        GameElement.currentTime = System.currentTimeMillis();
        if (this.timers != null) {
            for (Timer timer : this.timers) {
                if (!timer.isActive()) continue;
                timer.update();
            }
        }
        this.currentScreen.update();
        this.currentScreen.draw();
        if (this.currentScreen.foregroundFadeAlpha > 0.0f) {
            this.noStroke();
            this.fill(this.currentScreen.foregroundFadeColor, this.currentScreen.foregroundFadeAlpha);
            this.rect(0.0f, 0.0f, this.width, this.height);
        }
    }

    @Override
    public void mousePressed() {
        if (!ForegroundAnimation.activeAnimation) {
            this.currentScreen.mousePressed();
        }
        this.currentScreen.animMousePressed();
    }

    @Override
    public void mouseReleased() {
        if (!ForegroundAnimation.activeAnimation) {
            this.currentScreen.mouseReleased();
        }
        this.currentScreen.animMouseReleased();
    }

    @Override
    public void mouseDragged() {
        if (!ForegroundAnimation.activeAnimation) {
            this.currentScreen.mouseDragged();
        }
    }

    @Override
    public void keyPressed() {
        if (!ForegroundAnimation.activeAnimation) {
            this.currentScreen.keyPressed();
        }
    }

    @Override
    public void keyReleased() {
        if (!ForegroundAnimation.activeAnimation) {
            this.currentScreen.keyReleased();
        }
    }

    public void changeScreen(Screen screen) {
        this.currentScreen = screen;
        this.currentScreen.setup();
    }

    public static void main(String[] _args) {
        PApplet.main(new String[]{GameTemplate.class.getName()});
    }
}

