/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.x11.XVisualInfo;

public class X11GLCapabilities
extends GLCapabilities {
    private final XVisualInfo xVisualInfo;
    private final long fbcfg;
    private final int fbcfgid;

    public X11GLCapabilities(XVisualInfo xVisualInfo, long l, int n, GLProfile gLProfile) {
        super(gLProfile);
        this.xVisualInfo = xVisualInfo;
        this.fbcfg = l;
        this.fbcfgid = n;
    }

    public X11GLCapabilities(XVisualInfo xVisualInfo, GLProfile gLProfile) {
        super(gLProfile);
        this.xVisualInfo = xVisualInfo;
        this.fbcfg = 0L;
        this.fbcfgid = 0;
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new GLException(runtimeException);
        }
    }

    public final XVisualInfo getXVisualInfo() {
        return this.xVisualInfo;
    }

    public final int getXVisualID() {
        return null != this.xVisualInfo ? (int)this.xVisualInfo.getVisualid() : 0;
    }

    public final boolean hasXVisualInfo() {
        return null != this.xVisualInfo;
    }

    public final long getFBConfig() {
        return this.fbcfg;
    }

    public final int getFBConfigID() {
        return this.fbcfgid;
    }

    public final boolean hasFBConfig() {
        return 0L != this.fbcfg && this.fbcfgid != 0;
    }

    @Override
    public final int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        switch (vIDType) {
            case INTRINSIC: 
            case NATIVE: 
            case X11_XVISUAL: {
                return this.getXVisualID();
            }
            case X11_FBCONFIG: {
                return this.getFBConfigID();
            }
        }
        throw new NativeWindowException("Invalid type <" + (Object)((Object)vIDType) + ">");
    }

    @Override
    public StringBuffer toString(StringBuffer stringBuffer) {
        if (null == stringBuffer) {
            stringBuffer = new StringBuffer();
        }
        stringBuffer.append("glx vid ");
        if (this.hasXVisualInfo()) {
            stringBuffer.append("0x").append(Long.toHexString(this.xVisualInfo.getVisualid()));
        } else {
            stringBuffer.append("----");
        }
        stringBuffer.append(", fbc ");
        if (this.hasFBConfig()) {
            stringBuffer.append("0x").append(Integer.toHexString(this.fbcfgid));
        } else {
            stringBuffer.append("----");
        }
        stringBuffer.append(": ");
        return super.toString(stringBuffer);
    }
}

