/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDescriptionRuntime;
import jogamp.nativewindow.x11.XRenderDirectFormat;

public class XRenderPictFormat {
    StructAccessor accessor;
    private static final int mdIdx = MachineDescriptionRuntime.getStatic().ordinal();
    private static final int[] XRenderPictFormat_size = new int[]{32, 32, 40, 32, 32, 40};
    private static final int[] id_offset = new int[]{0, 0, 0, 0, 0, 0};
    private static final int[] type_offset = new int[]{4, 4, 8, 4, 4, 8};
    private static final int[] depth_offset = new int[]{8, 8, 12, 8, 8, 12};
    private static final int[] direct_offset = new int[]{12, 12, 16, 12, 12, 16};
    private static final int[] direct_size = new int[]{16, 16, 16, 16, 16, 16};
    private static final int[] colormap_offset = new int[]{28, 28, 32, 28, 28, 32};

    public static int size() {
        return XRenderPictFormat_size[mdIdx];
    }

    public static XRenderPictFormat create() {
        return XRenderPictFormat.create(Buffers.newDirectByteBuffer(XRenderPictFormat.size()));
    }

    public static XRenderPictFormat create(ByteBuffer byteBuffer) {
        return new XRenderPictFormat(byteBuffer);
    }

    XRenderPictFormat(ByteBuffer byteBuffer) {
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public XRenderPictFormat setId(long l) {
        this.accessor.setLongAt(id_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.pointerSizeInBytes());
        return this;
    }

    public long getId() {
        return this.accessor.getLongAt(id_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.pointerSizeInBytes());
    }

    public XRenderPictFormat setType(int n) {
        this.accessor.setIntAt(type_offset[mdIdx], n, MachineDescriptionRuntime.getStatic().md.intSizeInBytes());
        return this;
    }

    public int getType() {
        return this.accessor.getIntAt(type_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.intSizeInBytes());
    }

    public XRenderPictFormat setDepth(int n) {
        this.accessor.setIntAt(depth_offset[mdIdx], n, MachineDescriptionRuntime.getStatic().md.intSizeInBytes());
        return this;
    }

    public int getDepth() {
        return this.accessor.getIntAt(depth_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.intSizeInBytes());
    }

    public XRenderDirectFormat getDirect() {
        return XRenderDirectFormat.create(this.accessor.slice(direct_offset[mdIdx], direct_size[mdIdx]));
    }

    public XRenderPictFormat setColormap(long l) {
        this.accessor.setLongAt(colormap_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.pointerSizeInBytes());
        return this;
    }

    public long getColormap() {
        return this.accessor.getLongAt(colormap_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.pointerSizeInBytes());
    }
}

