/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Panose;
import jogamp.graph.font.typecast.ot.table.Table;

public class Os2Table
implements Table {
    private DirectoryEntry _de;
    private int _version;
    private short _xAvgCharWidth;
    private int _usWeightClass;
    private int _usWidthClass;
    private short _fsType;
    private short _ySubscriptXSize;
    private short _ySubscriptYSize;
    private short _ySubscriptXOffset;
    private short _ySubscriptYOffset;
    private short _ySuperscriptXSize;
    private short _ySuperscriptYSize;
    private short _ySuperscriptXOffset;
    private short _ySuperscriptYOffset;
    private short _yStrikeoutSize;
    private short _yStrikeoutPosition;
    private short _sFamilyClass;
    private Panose _panose;
    private int _ulUnicodeRange1;
    private int _ulUnicodeRange2;
    private int _ulUnicodeRange3;
    private int _ulUnicodeRange4;
    private int _achVendorID;
    private short _fsSelection;
    private int _usFirstCharIndex;
    private int _usLastCharIndex;
    private short _sTypoAscender;
    private short _sTypoDescender;
    private short _sTypoLineGap;
    private int _usWinAscent;
    private int _usWinDescent;
    private int _ulCodePageRange1;
    private int _ulCodePageRange2;
    private short _sxHeight;
    private short _sCapHeight;
    private int _usDefaultChar;
    private int _usBreakChar;
    private int _usMaxContext;

    protected Os2Table(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._version = dataInput.readUnsignedShort();
        this._xAvgCharWidth = dataInput.readShort();
        this._usWeightClass = dataInput.readUnsignedShort();
        this._usWidthClass = dataInput.readUnsignedShort();
        this._fsType = dataInput.readShort();
        this._ySubscriptXSize = dataInput.readShort();
        this._ySubscriptYSize = dataInput.readShort();
        this._ySubscriptXOffset = dataInput.readShort();
        this._ySubscriptYOffset = dataInput.readShort();
        this._ySuperscriptXSize = dataInput.readShort();
        this._ySuperscriptYSize = dataInput.readShort();
        this._ySuperscriptXOffset = dataInput.readShort();
        this._ySuperscriptYOffset = dataInput.readShort();
        this._yStrikeoutSize = dataInput.readShort();
        this._yStrikeoutPosition = dataInput.readShort();
        this._sFamilyClass = dataInput.readShort();
        byte[] byArray = new byte[10];
        dataInput.readFully(byArray);
        this._panose = new Panose(byArray);
        this._ulUnicodeRange1 = dataInput.readInt();
        this._ulUnicodeRange2 = dataInput.readInt();
        this._ulUnicodeRange3 = dataInput.readInt();
        this._ulUnicodeRange4 = dataInput.readInt();
        this._achVendorID = dataInput.readInt();
        this._fsSelection = dataInput.readShort();
        this._usFirstCharIndex = dataInput.readUnsignedShort();
        this._usLastCharIndex = dataInput.readUnsignedShort();
        this._sTypoAscender = dataInput.readShort();
        this._sTypoDescender = dataInput.readShort();
        this._sTypoLineGap = dataInput.readShort();
        this._usWinAscent = dataInput.readUnsignedShort();
        this._usWinDescent = dataInput.readUnsignedShort();
        this._ulCodePageRange1 = dataInput.readInt();
        this._ulCodePageRange2 = dataInput.readInt();
        if (this._version == 2) {
            this._sxHeight = dataInput.readShort();
            this._sCapHeight = dataInput.readShort();
            this._usDefaultChar = dataInput.readUnsignedShort();
            this._usBreakChar = dataInput.readUnsignedShort();
            this._usMaxContext = dataInput.readUnsignedShort();
        }
    }

    public int getVersion() {
        return this._version;
    }

    public short getAvgCharWidth() {
        return this._xAvgCharWidth;
    }

    public int getWeightClass() {
        return this._usWeightClass;
    }

    public int getWidthClass() {
        return this._usWidthClass;
    }

    public short getLicenseType() {
        return this._fsType;
    }

    public short getSubscriptXSize() {
        return this._ySubscriptXSize;
    }

    public short getSubscriptYSize() {
        return this._ySubscriptYSize;
    }

    public short getSubscriptXOffset() {
        return this._ySubscriptXOffset;
    }

    public short getSubscriptYOffset() {
        return this._ySubscriptYOffset;
    }

    public short getSuperscriptXSize() {
        return this._ySuperscriptXSize;
    }

    public short getSuperscriptYSize() {
        return this._ySuperscriptYSize;
    }

    public short getSuperscriptXOffset() {
        return this._ySuperscriptXOffset;
    }

    public short getSuperscriptYOffset() {
        return this._ySuperscriptYOffset;
    }

    public short getStrikeoutSize() {
        return this._yStrikeoutSize;
    }

    public short getStrikeoutPosition() {
        return this._yStrikeoutPosition;
    }

    public short getFamilyClass() {
        return this._sFamilyClass;
    }

    public Panose getPanose() {
        return this._panose;
    }

    public int getUnicodeRange1() {
        return this._ulUnicodeRange1;
    }

    public int getUnicodeRange2() {
        return this._ulUnicodeRange2;
    }

    public int getUnicodeRange3() {
        return this._ulUnicodeRange3;
    }

    public int getUnicodeRange4() {
        return this._ulUnicodeRange4;
    }

    public int getVendorID() {
        return this._achVendorID;
    }

    public short getSelection() {
        return this._fsSelection;
    }

    public int getFirstCharIndex() {
        return this._usFirstCharIndex;
    }

    public int getLastCharIndex() {
        return this._usLastCharIndex;
    }

    public short getTypoAscender() {
        return this._sTypoAscender;
    }

    public short getTypoDescender() {
        return this._sTypoDescender;
    }

    public short getTypoLineGap() {
        return this._sTypoLineGap;
    }

    public int getWinAscent() {
        return this._usWinAscent;
    }

    public int getWinDescent() {
        return this._usWinDescent;
    }

    public int getCodePageRange1() {
        return this._ulCodePageRange1;
    }

    public int getCodePageRange2() {
        return this._ulCodePageRange2;
    }

    public short getXHeight() {
        return this._sxHeight;
    }

    public short getCapHeight() {
        return this._sCapHeight;
    }

    public int getDefaultChar() {
        return this._usDefaultChar;
    }

    public int getBreakChar() {
        return this._usBreakChar;
    }

    public int getMaxContext() {
        return this._usMaxContext;
    }

    @Override
    public int getType() {
        return 1330851634;
    }

    public String toString() {
        return new StringBuffer().append("'OS/2' Table - OS/2 and Windows Metrics\n---------------------------------------").append("\n  'OS/2' version:      ").append(this._version).append("\n  xAvgCharWidth:       ").append(this._xAvgCharWidth).append("\n  usWeightClass:       ").append(this._usWeightClass).append("\n  usWidthClass:        ").append(this._usWidthClass).append("\n  fsType:              0x").append(Integer.toHexString(this._fsType).toUpperCase()).append("\n  ySubscriptXSize:     ").append(this._ySubscriptXSize).append("\n  ySubscriptYSize:     ").append(this._ySubscriptYSize).append("\n  ySubscriptXOffset:   ").append(this._ySubscriptXOffset).append("\n  ySubscriptYOffset:   ").append(this._ySubscriptYOffset).append("\n  ySuperscriptXSize:   ").append(this._ySuperscriptXSize).append("\n  ySuperscriptYSize:   ").append(this._ySuperscriptYSize).append("\n  ySuperscriptXOffset: ").append(this._ySuperscriptXOffset).append("\n  ySuperscriptYOffset: ").append(this._ySuperscriptYOffset).append("\n  yStrikeoutSize:      ").append(this._yStrikeoutSize).append("\n  yStrikeoutPosition:  ").append(this._yStrikeoutPosition).append("\n  sFamilyClass:        ").append(this._sFamilyClass >> 8).append("    subclass = ").append(this._sFamilyClass & 0xFF).append("\n  PANOSE:              ").append(this._panose.toString()).append("\n  Unicode Range 1( Bits 0 - 31 ): ").append(Integer.toHexString(this._ulUnicodeRange1).toUpperCase()).append("\n  Unicode Range 2( Bits 32- 63 ): ").append(Integer.toHexString(this._ulUnicodeRange2).toUpperCase()).append("\n  Unicode Range 3( Bits 64- 95 ): ").append(Integer.toHexString(this._ulUnicodeRange3).toUpperCase()).append("\n  Unicode Range 4( Bits 96-127 ): ").append(Integer.toHexString(this._ulUnicodeRange4).toUpperCase()).append("\n  achVendID:           '").append(this.getVendorIDAsString()).append("'\n  fsSelection:         0x").append(Integer.toHexString(this._fsSelection).toUpperCase()).append("\n  usFirstCharIndex:    0x").append(Integer.toHexString(this._usFirstCharIndex).toUpperCase()).append("\n  usLastCharIndex:     0x").append(Integer.toHexString(this._usLastCharIndex).toUpperCase()).append("\n  sTypoAscender:       ").append(this._sTypoAscender).append("\n  sTypoDescender:      ").append(this._sTypoDescender).append("\n  sTypoLineGap:        ").append(this._sTypoLineGap).append("\n  usWinAscent:         ").append(this._usWinAscent).append("\n  usWinDescent:        ").append(this._usWinDescent).append("\n  CodePage Range 1( Bits 0 - 31 ): ").append(Integer.toHexString(this._ulCodePageRange1).toUpperCase()).append("\n  CodePage Range 2( Bits 32- 63 ): ").append(Integer.toHexString(this._ulCodePageRange2).toUpperCase()).toString();
    }

    private String getVendorIDAsString() {
        return new StringBuffer().append((char)(this._achVendorID >> 24 & 0xFF)).append((char)(this._achVendorID >> 16 & 0xFF)).append((char)(this._achVendorID >> 8 & 0xFF)).append((char)(this._achVendorID & 0xFF)).toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

