/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font;

import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontSet;
import java.io.IOException;
import java.net.URLConnection;
import javax.media.opengl.GLException;

public class UbuntuFontLoader
implements FontSet {
    static final FontSet fontLoader = new UbuntuFontLoader();
    static final String[] availableFontFileNames = new String[]{"Ubuntu-R.ttf", "Ubuntu-RI.ttf", "Ubuntu-B.ttf", "Ubuntu-BI.ttf", "Ubuntu-L.ttf", "Ubuntu-LI.ttf", "Ubuntu-M.ttf", "Ubuntu-MI.ttf"};
    static final String relPath = "fonts/ubuntu/";
    static final IntObjectHashMap fontMap = new IntObjectHashMap();

    public static FontSet get() {
        return fontLoader;
    }

    private UbuntuFontLoader() {
    }

    static boolean is(int n, int n2) {
        return 0 != (n & n2);
    }

    @Override
    public Font getDefault() throws IOException {
        return this.get(0, 0);
    }

    @Override
    public Font get(int n, int n2) throws IOException {
        Font font = (Font)fontMap.get(n << 8 | n2);
        if (font != null) {
            return font;
        }
        switch (n) {
            case 0: 
            case 3: 
            case 4: {
                if (UbuntuFontLoader.is(n2, 4)) {
                    if (UbuntuFontLoader.is(n2, 8)) {
                        font = this.abspath(availableFontFileNames[3], n, n2);
                        break;
                    }
                    font = this.abspath(availableFontFileNames[2], n, n2);
                    break;
                }
                if (UbuntuFontLoader.is(n2, 8)) {
                    font = this.abspath(availableFontFileNames[1], n, n2);
                    break;
                }
                font = this.abspath(availableFontFileNames[0], n, n2);
                break;
            }
            case 1: {
                if (UbuntuFontLoader.is(n2, 8)) {
                    font = this.abspath(availableFontFileNames[5], n, n2);
                    break;
                }
                font = this.abspath(availableFontFileNames[4], n, n2);
                break;
            }
            case 2: {
                font = UbuntuFontLoader.is(n2, 8) ? this.abspath(availableFontFileNames[6], n, n2) : this.abspath(availableFontFileNames[7], n, n2);
            }
        }
        return font;
    }

    Font abspath(String string, int n, int n2) throws IOException {
        String string2 = "Problem loading font " + string + ", stream " + relPath + string;
        try {
            URLConnection uRLConnection = IOUtil.getResource(UbuntuFontLoader.class, relPath + string);
            if (null == uRLConnection) {
                throw new GLException(string2);
            }
            Font font = FontFactory.get(uRLConnection);
            if (null != font) {
                fontMap.put(n << 8 | n2, font);
                return font;
            }
            throw new IOException(string2);
        }
        catch (IOException iOException) {
            throw new IOException(string2, iOException);
        }
    }
}

