/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ProxySurface;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;

public abstract class GLDrawableFactory {
    static final String macosxFactoryClassNameCGL = "jogamp.opengl.macosx.cgl.MacOSXCGLDrawableFactory";
    static final String macosxFactoryClassNameAWTCGL = "jogamp.opengl.macosx.cgl.awt.MacOSXAWTCGLDrawableFactory";
    private static volatile boolean isInit = false;
    private static GLDrawableFactory eglFactory;
    private static GLDrawableFactory nativeOSFactory;
    protected static ArrayList<GLDrawableFactory> glDrawableFactories;
    private static boolean factoryShutdownHookRegistered;
    private static Thread factoryShutdownHook;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void initSingleton() {
        if (isInit) return;
        Class<GLDrawableFactory> clazz = GLDrawableFactory.class;
        synchronized (GLDrawableFactory.class) {
            if (isInit) return;
            isInit = true;
            GLDrawableFactory.initSingletonImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static final void initSingletonImpl() {
        GLDrawableFactory gLDrawableFactory;
        block15: {
            ClassLoader classLoader;
            block14: {
                GLDrawableFactory.registerFactoryShutdownHook();
                String string = NativeWindowFactory.getNativeWindowType(true);
                gLDrawableFactory = null;
                String string2 = Debug.getProperty("jogl.gldrawablefactory.class.name", true);
                classLoader = GLDrawableFactory.class.getClassLoader();
                if (null == string2) {
                    if (string.equals("X11")) {
                        string2 = "jogamp.opengl.x11.glx.X11GLXDrawableFactory";
                    } else if (string.equals("Windows")) {
                        string2 = "jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory";
                    } else if (string.equals("MacOSX")) {
                        string2 = ReflectionUtil.isClassAvailable(macosxFactoryClassNameAWTCGL, classLoader) ? macosxFactoryClassNameAWTCGL : macosxFactoryClassNameCGL;
                    } else if (GLProfile.DEBUG) {
                        System.err.println("GLDrawableFactory.static - No native OS Factory for: " + string + "; May use EGLDrawableFactory, if available.");
                    }
                }
                if (null != string2) {
                    if (GLProfile.DEBUG) {
                        System.err.println("GLDrawableFactory.static - Native OS Factory for: " + string + ": " + string2);
                    }
                    try {
                        gLDrawableFactory = (GLDrawableFactory)ReflectionUtil.createInstance(string2, classLoader);
                    }
                    catch (JogampRuntimeException jogampRuntimeException) {
                        if (!GLProfile.DEBUG) break block14;
                        System.err.println("Info: GLDrawableFactory.static - Native Platform: " + string + " - not available: " + string2);
                        jogampRuntimeException.printStackTrace();
                    }
                }
            }
            nativeOSFactory = gLDrawableFactory;
            gLDrawableFactory = null;
            try {
                gLDrawableFactory = (GLDrawableFactory)ReflectionUtil.createInstance("jogamp.opengl.egl.EGLDrawableFactory", classLoader);
            }
            catch (JogampRuntimeException jogampRuntimeException) {
                if (!GLProfile.DEBUG) break block15;
                System.err.println("Info: GLDrawableFactory.static - EGLDrawableFactory - not available");
                jogampRuntimeException.printStackTrace();
            }
        }
        eglFactory = gLDrawableFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void shutdown(GLProfile.ShutdownType shutdownType) {
        if (!isInit) return;
        Class<GLDrawableFactory> clazz = GLDrawableFactory.class;
        synchronized (GLDrawableFactory.class) {
            if (!isInit) return;
            isInit = false;
            GLDrawableFactory.unregisterFactoryShutdownHook();
            GLDrawableFactory.shutdownImpl(shutdownType);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownImpl(GLProfile.ShutdownType shutdownType) {
        ArrayList<GLDrawableFactory> arrayList = glDrawableFactories;
        synchronized (arrayList) {
            for (int i = 0; i < glDrawableFactories.size(); ++i) {
                glDrawableFactories.get(i).destroy(shutdownType);
            }
            glDrawableFactories.clear();
            nativeOSFactory = null;
            eglFactory = null;
        }
    }

    private static synchronized void registerFactoryShutdownHook() {
        if (factoryShutdownHookRegistered) {
            return;
        }
        factoryShutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                GLDrawableFactory.shutdownImpl(GLProfile.ShutdownType.COMPLETE);
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Runtime.getRuntime().addShutdownHook(factoryShutdownHook);
                return null;
            }
        });
        factoryShutdownHookRegistered = true;
    }

    private static synchronized void unregisterFactoryShutdownHook() {
        if (!factoryShutdownHookRegistered) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Runtime.getRuntime().removeShutdownHook(factoryShutdownHook);
                return null;
            }
        });
        factoryShutdownHookRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLDrawableFactory() {
        ArrayList<GLDrawableFactory> arrayList = glDrawableFactories;
        synchronized (arrayList) {
            glDrawableFactories.add(this);
        }
    }

    protected void enterThreadCriticalZone() {
    }

    protected void leaveThreadCriticalZone() {
    }

    protected abstract void destroy(GLProfile.ShutdownType var1);

    public abstract AbstractGraphicsDevice getDefaultDevice();

    public abstract boolean getIsDeviceCompatible(AbstractGraphicsDevice var1);

    protected final AbstractGraphicsDevice validateDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = this.getDefaultDevice();
            if (null == abstractGraphicsDevice) {
                throw new InternalError("no default device");
            }
            if (GLProfile.DEBUG) {
                System.err.println("Info: " + this.getClass().getSimpleName() + ".validateDevice: using default device : " + abstractGraphicsDevice);
            }
        }
        if (!this.getIsDeviceCompatible(abstractGraphicsDevice)) {
            if (GLProfile.DEBUG) {
                System.err.println("Info: " + this.getClass().getSimpleName() + ".validateDevice: device not compatible : " + abstractGraphicsDevice);
            }
            return null;
        }
        return abstractGraphicsDevice;
    }

    protected abstract Thread getSharedResourceThread();

    protected abstract boolean createSharedResource(AbstractGraphicsDevice var1);

    public static GLDrawableFactory getDesktopFactory() {
        GLProfile.initSingleton();
        return nativeOSFactory;
    }

    public static GLDrawableFactory getEGLFactory() {
        GLProfile.initSingleton();
        return eglFactory;
    }

    public static GLDrawableFactory getFactory(GLProfile gLProfile) throws GLException {
        return GLDrawableFactory.getFactoryImpl(gLProfile.getImplName());
    }

    protected static GLDrawableFactory getFactoryImpl(String string) throws GLException {
        if (GLProfile.usesNativeGLES(string)) {
            if (null != eglFactory) {
                return eglFactory;
            }
        } else if (null != nativeOSFactory) {
            return nativeOSFactory;
        }
        throw new GLException("No GLDrawableFactory available for profile: " + string);
    }

    protected static GLDrawableFactory getFactoryImpl(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        if (null != nativeOSFactory && nativeOSFactory.getIsDeviceCompatible(abstractGraphicsDevice)) {
            return nativeOSFactory;
        }
        if (null != eglFactory && eglFactory.getIsDeviceCompatible(abstractGraphicsDevice)) {
            return eglFactory;
        }
        throw new GLException("No native platform GLDrawableFactory, nor EGLDrawableFactory available: " + abstractGraphicsDevice);
    }

    public final List<GLCapabilitiesImmutable> getAvailableCapabilities(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null != (abstractGraphicsDevice = this.validateDevice(abstractGraphicsDevice))) {
            return this.getAvailableCapabilitiesImpl(abstractGraphicsDevice);
        }
        return null;
    }

    protected abstract List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice var1);

    public abstract GLDrawable createGLDrawable(NativeSurface var1) throws IllegalArgumentException, GLException;

    public abstract GLDrawable createOffscreenDrawable(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5) throws GLException;

    public abstract NativeSurface createOffscreenSurface(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5);

    public abstract ProxySurface createProxySurface(AbstractGraphicsDevice var1, long var2, GLCapabilitiesImmutable var4, GLCapabilitiesChooser var5);

    public abstract boolean canCreateGLPbuffer(AbstractGraphicsDevice var1);

    public abstract GLPbuffer createGLPbuffer(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5, GLContext var6) throws GLException;

    public abstract GLContext createExternalGLContext() throws GLException;

    public abstract boolean canCreateExternalGLDrawable(AbstractGraphicsDevice var1);

    public abstract GLDrawable createExternalGLDrawable() throws GLException;

    static {
        glDrawableFactories = new ArrayList();
        factoryShutdownHookRegistered = false;
        factoryShutdownHook = null;
    }
}

