/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow.util;

import javax.media.nativewindow.util.DimensionImmutable;

public class Dimension
implements Cloneable,
DimensionImmutable {
    int width;
    int height;

    public Dimension() {
        this(0, 0);
    }

    public Dimension(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must be within: [0..2147483647]");
        }
        this.width = n;
        this.height = n2;
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public Dimension scale(int n) {
        this.width *= n;
        this.height *= n;
        return this;
    }

    public Dimension add(Dimension dimension) {
        this.width += dimension.width;
        this.height += dimension.height;
        return this;
    }

    public String toString() {
        return new String(this.width + " x " + this.height);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Dimension) {
            Dimension dimension = (Dimension)object;
            return this.height == dimension.height && this.width == dimension.width;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 31 + this.width;
        return (n << 5) - n + this.height;
    }
}

