/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openmax;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.openmax.OMXEventListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLExt;

public class OMXInstance {
    private long moviePtr = 0L;
    protected String path = null;
    protected URL url = null;
    protected Texture texture = null;
    protected float playSpeed = 1.0f;
    protected int width = 0;
    protected int height = 0;
    protected int fps = 0;
    protected long bps = 0L;
    protected long totalFrames = 0L;
    protected String acodec = null;
    protected String vcodec = null;
    protected int o_width = 0;
    protected int o_height = 0;
    protected int o_fps = 0;
    protected long o_bps = 0L;
    protected long o_totalFrames = 0L;
    private EGLImageTexture[] eglImgTexs = null;
    private HashMap eglImgTexsMap = new HashMap();
    protected int textureNum;
    private EGLExt eglExt = null;
    private long eglSurface = 0L;
    private long eglDisplay = 0L;
    private long eglContext = 0L;
    private int sWidth = 0;
    private int sHeight = 0;
    private ArrayList eventListeners = new ArrayList();

    private GL initGLData(GL gL) {
        if (null == gL) {
            throw new RuntimeException("No current GL");
        }
        EGLContext eGLContext = (EGLContext)gL.getContext();
        if (null == eGLContext) {
            throw new RuntimeException("No current EGL context");
        }
        EGLDrawable eGLDrawable = (EGLDrawable)eGLContext.getGLDrawable();
        if (null == eGLDrawable) {
            throw new RuntimeException("No valid drawable");
        }
        this.eglContext = eGLContext.getHandle();
        this.eglDisplay = eGLDrawable.getDisplay();
        this.eglSurface = eGLDrawable.getHandle();
        this.eglExt = eGLContext.getEGLExt();
        if (null == this.eglExt) {
            throw new RuntimeException("No valid EGLExt");
        }
        int[] nArray = new int[1];
        EGL.eglQuerySurface(this.eglDisplay, this.eglSurface, 12375, nArray, 0);
        this.sWidth = nArray[0];
        EGL.eglQuerySurface(this.eglDisplay, this.eglSurface, 12374, nArray, 0);
        this.sHeight = nArray[0];
        System.out.println("surface size: " + this.width + "x" + this.height);
        System.out.println(eGLDrawable);
        System.out.println(eGLContext);
        System.out.println("EGL Extensions : " + EGL.eglQueryString(this.eglDisplay, 12373));
        System.out.println("EGL CLIENT APIs: " + EGL.eglQueryString(this.eglDisplay, 12429));
        return gL;
    }

    public OMXInstance() {
        this.moviePtr = this._createInstance();
        if (0L == this.moviePtr) {
            throw new GLException("Couldn't create OMXInstance");
        }
    }

    native long _createInstance();

    public synchronized void setStream(int n, URL uRL) {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        this.textureNum = n;
        this.url = uRL;
        if (this.url == null) {
            System.out.println("setURL (null)");
            this.stop();
            return;
        }
        this.path = null;
        if (this.url.getProtocol() == null || "file".equals(this.url.getProtocol())) {
            try {
                File file = new File(this.url.getPath());
                if (!file.exists()) {
                    throw new RuntimeException(new FileNotFoundException(file.toString()));
                }
                this.path = file.getCanonicalPath();
                System.out.println("setURL: path " + this.path);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception);
            }
        }
        this.path = this.replaceAll(this.path, "\\", "/").trim();
        if (null == this.path) {
            throw new RuntimeException("Couldn't parse stream URL: " + this.url);
        }
        System.out.println("setURL: clean path " + this.path);
        System.out.println("setURL: p1 " + this);
        this._setStream(this.moviePtr, n, this.path);
        System.out.println("setURL: p2 " + this);
    }

    native void _setStream(long var1, int var3, String var4);

    public synchronized void setStreamAllEGLImageTexture2D(GL gL) {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        if (null == this.vcodec) {
            return;
        }
        gL = this.initGLData(gL);
        if (null != this.eglImgTexs) {
            this.removeAllEGLImageTexture2D(gL);
        } else {
            this.eglImgTexs = new EGLImageTexture[this.textureNum];
        }
        int[] nArray = new int[1];
        this.errorCheckGL(gL, "i.1");
        gL.glEnable(3553);
        this.errorCheckGL(gL, "i.2");
        for (int i = 0; i < this.textureNum; ++i) {
            String string = String.valueOf(i);
            gL.glGenTextures(1, nArray, 0);
            int n = nArray[0];
            int n2 = gL.glGetError();
            if (n2 != 0 || 0 > n) {
                throw new RuntimeException("TextureName creation failed: " + n2);
            }
            gL.glBindTexture(3553, n);
            gL.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5121, null);
            gL.glTexParameteri(3553, 10241, 9728);
            gL.glTexParameteri(3553, 10240, 9728);
            long l = 0L;
            long l2 = 0L;
            nArray[0] = 12344;
            l = this.eglExt.eglCreateImageKHR(this.eglDisplay, this.eglContext, 12465, n, nArray, 0);
            if (0L == l) {
                throw new RuntimeException("EGLImage creation failed: " + EGL.eglGetError() + ", dpy " + this.eglDisplay + ", ctx " + this.eglContext + ", tex " + n);
            }
            nArray[0] = 12344;
            l2 = this.eglExt.eglCreateSyncKHR(this.eglDisplay, 12537, nArray, 0);
            this._setStreamEGLImageTexture2D(this.moviePtr, i, n, l, l2);
            this.eglImgTexs[i] = new EGLImageTexture(TextureIO.newTexture(n, 3553, this.width, this.height, this.width, this.height, true), l, l2);
            this.eglImgTexsMap.put(new Integer(n), this.eglImgTexs[i]);
        }
        gL.glDisable(3553);
    }

    native void _setStreamEGLImageTexture2D(long var1, int var3, int var4, long var5, long var7);

    public synchronized void activateStream() {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        this._activateStream(this.moviePtr);
    }

    native void _activateStream(long var1);

    public synchronized void detachVideoRenderer() {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        this._detachVideoRenderer(this.moviePtr);
    }

    native void _detachVideoRenderer(long var1);

    public synchronized void attachVideoRenderer() {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        this._attachVideoRenderer(this.moviePtr);
    }

    native void _attachVideoRenderer(long var1);

    public synchronized void setPlaySpeed(float f) {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        this._setPlaySpeed(this.moviePtr, f);
        this.playSpeed = f;
    }

    public synchronized float getPlaySpeed() {
        return this.playSpeed;
    }

    native void _setPlaySpeed(long var1, float var3);

    public synchronized float play() {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        return this._play(this.moviePtr);
    }

    native float _play(long var1);

    public synchronized float pause() {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        return this._pause(this.moviePtr);
    }

    native float _pause(long var1);

    public synchronized float stop() {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        return this._stop(this.moviePtr);
    }

    native float _stop(long var1);

    public synchronized float seek(float f) {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        return this._seek(this.moviePtr, f);
    }

    native float _seek(long var1, float var3);

    public synchronized Texture getLastTextureID() {
        return this.texture;
    }

    public synchronized Texture getNextTextureID() {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        this.texture = null;
        EGLImageTexture eGLImageTexture = (EGLImageTexture)this.eglImgTexsMap.get(new Integer(this._getNextTextureID(this.moviePtr)));
        if (null != eGLImageTexture) {
            this.texture = eGLImageTexture.texture;
        }
        return this.texture;
    }

    native int _getNextTextureID(long var1);

    public synchronized float getCurrentPosition() {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        return this._getCurrentPosition(this.moviePtr);
    }

    native float _getCurrentPosition(long var1);

    public synchronized void destroy(GL gL) {
        this.removeAllEGLImageTexture2D(gL);
        if (this.moviePtr != 0L) {
            long l = this.moviePtr;
            this.moviePtr = 0L;
            this._destroyInstance(l);
            this.eglExt = null;
            this.eglSurface = 0L;
            this.eglDisplay = 0L;
            this.eglContext = 0L;
        }
    }

    protected synchronized void finalize() {
        if (this.moviePtr != 0L) {
            this.destroy(null);
        }
    }

    native void _destroyInstance(long var1);

    public synchronized boolean isValid() {
        return this.moviePtr != 0L;
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized URL getURL() {
        return this.url;
    }

    public synchronized String getVideoCodec() {
        return this.vcodec;
    }

    public synchronized String getAudioCodec() {
        return this.acodec;
    }

    public synchronized long getTotalFrames() {
        return this.totalFrames;
    }

    public synchronized long getBitrate() {
        return this.bps;
    }

    public synchronized int getFramerate() {
        return this.fps;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public synchronized int getHeight() {
        return this.height;
    }

    public synchronized String toString() {
        return "OMXInstance [ stream [ video [ " + this.vcodec + ", " + this.width + "x" + this.height + ", " + this.fps + "fps, " + this.bps + "bsp, " + this.totalFrames + "f ] ] ]";
    }

    private void saveAttributes() {
        this.o_width = this.width;
        this.o_height = this.height;
        this.o_fps = this.fps;
        this.o_bps = this.bps;
        this.o_totalFrames = this.totalFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attributesUpdated() {
        int n = 0;
        if (this.o_width != this.width || this.o_height != this.height) {
            n |= 1;
        }
        if (this.o_fps != this.fps) {
            n |= 2;
        }
        if (this.o_bps != this.bps) {
            n |= 4;
        }
        if (this.o_totalFrames != this.totalFrames) {
            n |= 8;
        }
        if (0 == n) {
            return;
        }
        ArrayList arrayList = null;
        OMXInstance oMXInstance = this;
        synchronized (oMXInstance) {
            arrayList = this.eventListeners;
        }
        for (OMXEventListener oMXEventListener : arrayList) {
            oMXEventListener.changedAttributes(this, n);
        }
    }

    private String replaceAll(String string, String string2, String string3) {
        int n;
        String string4 = null;
        int n2 = 0;
        string4 = new String();
        while ((n = string.indexOf(string2, n2)) >= 0) {
            string4 = string4.concat(string.substring(n2, n));
            string4 = string4.concat(string3);
            n2 = n + 1;
        }
        return string4.concat(string.substring(n2, string.length()));
    }

    private void removeAllEGLImageTexture2D(GL gL) {
        if (this.moviePtr != 0L) {
            if (null == this.eglExt) {
                throw new RuntimeException("No valid EGLExt");
            }
            this.texture = null;
            for (int i = 0; i < this.textureNum; ++i) {
                if (null == this.eglImgTexs[i]) continue;
                if (0L != this.eglImgTexs[i].image) {
                    this.eglExt.eglDestroyImageKHR(this.eglDisplay, this.eglImgTexs[i].image);
                }
                if (0L != this.eglImgTexs[i].sync) {
                    this.eglExt.eglDestroySyncKHR(this.eglDisplay, this.eglImgTexs[i].sync);
                }
                if (null != gL) {
                    this.eglImgTexs[i].texture.destroy(gL);
                }
                this.eglImgTexs[i] = null;
            }
            this.eglImgTexsMap.clear();
        }
    }

    private void errorCheckGL(GL gL, String string) {
        int n = gL.glGetError();
        if (n != 0) {
            System.out.println("GL Error: (" + string + "): " + n);
        }
    }

    private void errorCheckEGL(String string) {
        int n = EGL.eglGetError();
        if (n != 12288) {
            System.out.println("EGL Error: (" + string + "): 0x" + Integer.toHexString(n));
        }
    }

    public synchronized void addEventListener(OMXEventListener oMXEventListener) {
        if (oMXEventListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.eventListeners.clone();
        arrayList.add(oMXEventListener);
        this.eventListeners = arrayList;
    }

    public synchronized void removeEventListener(OMXEventListener oMXEventListener) {
        if (oMXEventListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.eventListeners.clone();
        arrayList.remove(oMXEventListener);
        this.eventListeners = arrayList;
    }

    public synchronized OMXEventListener[] getEventListeners() {
        return (OMXEventListener[])this.eventListeners.toArray();
    }

    static class EGLImageTexture {
        protected Texture texture;
        protected long image;
        protected long sync;

        public EGLImageTexture(Texture texture, long l, long l2) {
            this.texture = texture;
            this.image = l;
            this.sync = l2;
        }

        public String toString() {
            return "EGLImageTexture[" + this.texture + ", image " + this.image + ", sync " + this.sync + "]";
        }
    }
}

