/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.DefaultAnimatorImpl;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;
import jogamp.opengl.FPSCounterImpl;

public abstract class AnimatorBase
implements GLAnimatorControl {
    protected static final boolean DEBUG = Debug.debug("Animator");
    private static int animatorCount = 0;
    protected ArrayList<GLAutoDrawable> drawables = new ArrayList();
    protected boolean drawablesEmpty;
    protected AnimatorImpl impl;
    protected String baseName;
    protected Thread animThread;
    protected boolean ignoreExceptions;
    protected boolean printExceptions;
    protected FPSCounterImpl fpsCounter = new FPSCounterImpl();
    protected RecursiveLock stateSync = LockFactory.createRecursiveLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimatorBase() {
        if (GLProfile.isAWTAvailable()) {
            try {
                this.impl = (AnimatorImpl)Class.forName("com.jogamp.opengl.util.AWTAnimatorImpl").newInstance();
                this.baseName = "AWTAnimator";
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (null == this.impl) {
            this.impl = new DefaultAnimatorImpl();
            this.baseName = "Animator";
        }
        Class<Animator> clazz = Animator.class;
        synchronized (Animator.class) {
            this.baseName = this.baseName.concat("-" + ++animatorCount);
            this.drawablesEmpty = true;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract String getBaseName(String var1);

    public synchronized void add(GLAutoDrawable gLAutoDrawable) {
        if (DEBUG) {
            System.err.println("Animator add: " + gLAutoDrawable.hashCode() + " - " + Thread.currentThread().getName());
        }
        boolean bl = this.pause();
        this.drawables.add(gLAutoDrawable);
        this.drawablesEmpty = this.drawables.size() == 0;
        gLAutoDrawable.setAnimator(this);
        if (bl) {
            this.resume();
        }
        if (this.impl.blockUntilDone(this.animThread)) {
            while (this.isStarted() && !this.isPaused() && !this.isAnimating()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.notifyAll();
    }

    @Override
    public synchronized void remove(GLAutoDrawable gLAutoDrawable) {
        if (DEBUG) {
            System.err.println("Animator remove: " + gLAutoDrawable.hashCode() + " - " + Thread.currentThread().getName() + ": " + this.toString());
        }
        boolean bl = this.pause();
        this.drawables.remove(gLAutoDrawable);
        this.drawablesEmpty = this.drawables.size() == 0;
        gLAutoDrawable.setAnimator(null);
        if (bl) {
            this.resume();
        }
        if (this.impl.blockUntilDone(this.animThread)) {
            while (this.isStarted() && this.drawablesEmpty && this.isAnimating()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.notifyAll();
    }

    protected void display() {
        this.impl.display(this.drawables, this.ignoreExceptions, this.printExceptions);
        this.fpsCounter.tickFPS();
    }

    @Override
    public final void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.fpsCounter.setUpdateFPSFrames(n, printStream);
    }

    @Override
    public final void resetFPSCounter() {
        this.fpsCounter.resetFPSCounter();
    }

    @Override
    public final int getUpdateFPSFrames() {
        return this.fpsCounter.getUpdateFPSFrames();
    }

    @Override
    public final long getFPSStartTime() {
        return this.fpsCounter.getFPSStartTime();
    }

    @Override
    public final long getLastFPSUpdateTime() {
        return this.fpsCounter.getLastFPSUpdateTime();
    }

    @Override
    public final long getLastFPSPeriod() {
        return this.fpsCounter.getLastFPSPeriod();
    }

    @Override
    public final float getLastFPS() {
        return this.fpsCounter.getLastFPS();
    }

    @Override
    public final int getTotalFPSFrames() {
        return this.fpsCounter.getTotalFPSFrames();
    }

    @Override
    public final long getTotalFPSDuration() {
        return this.fpsCounter.getTotalFPSDuration();
    }

    @Override
    public final float getTotalFPS() {
        return this.fpsCounter.getTotalFPS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Thread getThread() {
        this.stateSync.lock();
        try {
            Thread thread = this.animThread;
            return thread;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    public void setIgnoreExceptions(boolean bl) {
        this.ignoreExceptions = bl;
    }

    public void setPrintExceptions(boolean bl) {
        this.printExceptions = bl;
    }

    public String toString() {
        return this.getClass().getName() + "[started " + this.isStarted() + ", animating " + this.isAnimating() + ", paused " + this.isPaused() + ", drawable " + this.drawables.size() + "]";
    }

    public static interface AnimatorImpl {
        public void display(ArrayList<GLAutoDrawable> var1, boolean var2, boolean var3);

        public boolean blockUntilDone(Thread var1);
    }
}

