/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.awt;

import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.image.ColorModel;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import jogamp.nativewindow.Debug;

public class AWTGraphicsConfiguration
extends DefaultGraphicsConfiguration
implements Cloneable {
    private GraphicsConfiguration config;
    AbstractGraphicsConfiguration encapsulated;

    public AWTGraphicsConfiguration(AWTGraphicsScreen aWTGraphicsScreen, CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, GraphicsConfiguration graphicsConfiguration, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(aWTGraphicsScreen, capabilitiesImmutable, capabilitiesImmutable2);
        this.config = graphicsConfiguration;
        this.encapsulated = abstractGraphicsConfiguration;
    }

    private AWTGraphicsConfiguration(AWTGraphicsScreen aWTGraphicsScreen, CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, GraphicsConfiguration graphicsConfiguration) {
        super(aWTGraphicsScreen, capabilitiesImmutable, capabilitiesImmutable2);
        this.config = graphicsConfiguration;
        this.encapsulated = null;
    }

    public static AWTGraphicsConfiguration create(Component component, CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration;
        Object object;
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (null == graphicsConfiguration) {
            throw new NativeWindowException("AWTGraphicsConfiguration.create: Null AWT GraphicsConfiguration @ " + component);
        }
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        if (null == graphicsDevice) {
            throw new NativeWindowException("AWTGraphicsConfiguration.create: Null AWT GraphicsDevice @ " + graphicsConfiguration);
        }
        AWTGraphicsDevice aWTGraphicsDevice = new AWTGraphicsDevice(graphicsDevice, 0);
        AWTGraphicsScreen aWTGraphicsScreen = new AWTGraphicsScreen(aWTGraphicsDevice);
        if (null == capabilitiesImmutable) {
            object = graphicsDevice.getDefaultConfiguration();
            capabilitiesImmutable = AWTGraphicsConfiguration.setupCapabilitiesRGBABits(capabilitiesImmutable2, (GraphicsConfiguration)object);
        }
        if ((abstractGraphicsConfiguration = ((GraphicsConfigurationFactory)(object = GraphicsConfigurationFactory.getFactory(aWTGraphicsDevice))).chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, null, aWTGraphicsScreen)) instanceof AWTGraphicsConfiguration) {
            return (AWTGraphicsConfiguration)abstractGraphicsConfiguration;
        }
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, capabilitiesImmutable, capabilitiesImmutable2, graphicsConfiguration);
    }

    @Override
    public void setChosenCapabilities(CapabilitiesImmutable capabilitiesImmutable) {
        super.setChosenCapabilities(capabilitiesImmutable);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public GraphicsConfiguration getAWTGraphicsConfiguration() {
        return this.config;
    }

    @Override
    public AbstractGraphicsConfiguration getNativeGraphicsConfiguration() {
        return null != this.encapsulated ? this.encapsulated : this;
    }

    public static CapabilitiesImmutable setupCapabilitiesRGBABits(CapabilitiesImmutable capabilitiesImmutable, GraphicsConfiguration graphicsConfiguration) {
        Capabilities capabilities = (Capabilities)capabilitiesImmutable.cloneMutable();
        ColorModel colorModel = graphicsConfiguration.getColorModel();
        if (null == colorModel) {
            throw new NativeWindowException("Could not determine AWT ColorModel");
        }
        int n = colorModel.getPixelSize();
        int n2 = 0;
        int[] nArray = colorModel.getComponentSize();
        if (nArray.length >= 3) {
            capabilities.setRedBits(nArray[0]);
            n2 += nArray[0];
            capabilities.setGreenBits(nArray[1]);
            n2 += nArray[1];
            capabilities.setBlueBits(nArray[2]);
            n2 += nArray[2];
        }
        if (nArray.length >= 4) {
            capabilities.setAlphaBits(nArray[3]);
            n2 += nArray[3];
        } else {
            capabilities.setAlphaBits(0);
        }
        if (Debug.debugAll() && n != n2) {
            System.err.println("AWT Colormodel bits per components/pixel mismatch: " + n2 + " != " + n);
        }
        return capabilities;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getScreen() + ",\n\tchosen    " + this.capabilitiesChosen + ",\n\trequested " + this.capabilitiesRequested + ",\n\t" + this.config + ",\n\tencapsulated " + this.encapsulated + "]";
    }
}

